/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.derquinse.common.collect.ImmutableHierarchy;

final class RegularImmutableHierarchy<E>
extends ImmutableHierarchy<E> {
    private final transient ImmutableSet<E> elements;
    private final ImmutableList<E> firstLevel;
    private final transient ImmutableMap<E, E> parents;
    private final ImmutableListMultimap<E, E> children;
    private final transient ConcurrentMap<E, ImmutableSet<E>> descendants;

    RegularImmutableHierarchy(ImmutableHierarchy.Builder<E> builder) {
        this.elements = ImmutableSet.copyOf(builder.getElements());
        this.firstLevel = ImmutableList.copyOf(builder.getFirstLevel());
        this.parents = ImmutableMap.copyOf(builder.getParents());
        this.children = ImmutableListMultimap.copyOf(builder.getChildren());
        Preconditions.checkArgument((this.elements.size() == this.firstLevel.size() + this.children.size() ? 1 : 0) != 0, (Object)"Inconsistent hierarchy.");
        this.descendants = new MapMaker().initialCapacity(this.elements.size()).makeMap();
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.elements;
    }

    @Override
    public List<E> getChildren(@Nullable E element) {
        if (element == null) {
            return this.getFirstLevel();
        }
        this.checkMember(element);
        return this.children.get(element);
    }

    @Override
    public List<E> getFirstLevel() {
        return this.firstLevel;
    }

    @Override
    public E getParent(E element) {
        this.checkMember(element);
        return (E)this.parents.get(element);
    }

    @Override
    ImmutableSet<E> getMemberDescendants(E element) {
        this.checkMember(element);
        ImmutableSet set = (ImmutableSet)this.descendants.get(element);
        if (set != null) {
            return set;
        }
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (E e : this.getChildren(element)) {
            b.add(e);
            b.addAll(this.getDescendants(e));
        }
        set = b.build();
        this.descendants.put(element, set);
        return set;
    }
}

