/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.i18n;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.derquinse.common.i18n.AbstractLocalized;
import net.derquinse.common.i18n.UnableToLocalizeException;

public final class BundleLocalized<T>
extends AbstractLocalized<T> {
    public static final String SUFFIX = "Bundle";
    private final String baseName;
    private final String key;

    public BundleLocalized(String baseName, String key) {
        this.baseName = (String)Preconditions.checkNotNull((Object)baseName, (Object)"A bundle base name must be provided");
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"A bundle key must be provided");
    }

    public BundleLocalized(Class<?> type, String key) {
        this(((Class)Preconditions.checkNotNull(type, (Object)"A base type must be provided")).getName() + SUFFIX, key);
    }

    @Override
    public T apply(Locale locale) {
        try {
            ResourceBundle bundle = locale == null ? ResourceBundle.getBundle(this.baseName) : ResourceBundle.getBundle(this.baseName, locale);
            Object value = bundle.getObject(this.key);
            return (T)value;
        }
        catch (MissingResourceException e) {
            throw new UnableToLocalizeException(e);
        }
        catch (ClassCastException e) {
            throw new UnableToLocalizeException(e);
        }
    }
}

