/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.i18n;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Locale;
import net.derquinse.common.base.NotInstantiable;

public final class Locales
extends NotInstantiable {
    private Locales() {
    }

    private static String clean(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public static Locale getParent(Locale locale) {
        if (locale == null) {
            return null;
        }
        String lang = Locales.clean(locale.getLanguage());
        String country = Locales.clean(locale.getCountry());
        String variant = Locales.clean(locale.getVariant());
        if (variant != null) {
            if (country != null) {
                return new Locale(lang, country);
            }
            return new Locale(lang);
        }
        if (country != null) {
            return new Locale(lang);
        }
        return null;
    }

    public static Locale fromString(String localeString) {
        Preconditions.checkNotNull((Object)localeString);
        Preconditions.checkArgument((localeString.length() > 0 ? 1 : 0) != 0);
        String[] split = localeString.split("_");
        int n = split.length;
        if (n == 1) {
            return new Locale(split[0]);
        }
        if (n == 2) {
            return new Locale(split[0], split[1]);
        }
        if (n == 3) {
            return new Locale(split[0], split[1], split[2]);
        }
        throw new IllegalArgumentException("Unable to parse locale [" + localeString + ']');
    }

    public static Function<String, Locale> fromString() {
        return FromString.INSTANCE;
    }

    public static Locale safeFromString(String localeString) {
        if (localeString == null) {
            return null;
        }
        try {
            return Locales.fromString(localeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Function<String, Locale> safeFromString() {
        return SafeFromString.INSTANCE;
    }

    private static enum SafeFromString implements Function<String, Locale>
    {
        INSTANCE;


        public Locale apply(String from) {
            return Locales.safeFromString(from);
        }

        public String toString() {
            return "Locales.safeFromString";
        }
    }

    private static enum FromString implements Function<String, Locale>
    {
        INSTANCE;


        public Locale apply(String from) {
            return Locales.fromString(from);
        }

        public String toString() {
            return "Locales.fromString";
        }
    }
}

