/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.i18n;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.derquinse.common.base.Builder;
import net.derquinse.common.i18n.AbstractLocalized;
import net.derquinse.common.i18n.Locales;
import net.derquinse.common.i18n.Localized;
import net.derquinse.common.i18n.Unlocalized;

public final class LocalizedBuilder<T>
implements Builder<Localized<T>> {
    private static final String NULL_DEFAULT = "Default value can't be null";
    private static final String NULL_LOCALE = "Null locales not allowed";
    private static final String NULL_VALUE = "Null values not allowed";
    private T defaultValue;
    private final Map<Locale, T> values = Maps.newHashMap();

    public static <T> LocalizedBuilder<T> create() {
        return new LocalizedBuilder<T>();
    }

    public static <T> LocalizedBuilder<T> create(T defaultValue) {
        return new LocalizedBuilder<T>().setDefault(defaultValue);
    }

    private LocalizedBuilder() {
    }

    public LocalizedBuilder<T> setDefault(T value) {
        this.defaultValue = Preconditions.checkNotNull(value, (Object)NULL_DEFAULT);
        return this;
    }

    public LocalizedBuilder<T> put(Locale locale, T value) {
        Preconditions.checkNotNull((Object)locale, (Object)NULL_LOCALE);
        Preconditions.checkNotNull(value, (Object)NULL_VALUE);
        this.values.put(locale, value);
        return this;
    }

    public LocalizedBuilder<T> putAll(Map<? extends Locale, ? extends T> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        for (Map.Entry<Locale, T> entry : values.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Localized<T> build() {
        Preconditions.checkState((this.defaultValue != null ? 1 : 0) != 0, (Object)NULL_DEFAULT);
        if (this.values.isEmpty()) {
            return Unlocalized.of(this.defaultValue);
        }
        return new LocalizedValue(this.defaultValue, this.values);
    }

    private static final class LocalizedValue<T>
    extends AbstractLocalized<T> {
        private final T defaultValue;
        private final ImmutableMap<Locale, T> values;

        private LocalizedValue(T defaultValue, Map<Locale, T> values) {
            this.defaultValue = defaultValue;
            this.values = ImmutableMap.copyOf(values);
        }

        @Override
        public T get() {
            return this.defaultValue;
        }

        @Override
        public T apply(Locale locale) {
            while (locale != null) {
                Object value = this.values.get((Object)locale);
                if (value != null) {
                    return (T)value;
                }
                locale = Locales.getParent(locale);
            }
            return this.defaultValue;
        }
    }
}

