/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.i18n;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Locale;
import net.derquinse.common.i18n.AbstractLocalized;
import net.derquinse.common.i18n.Localized;
import net.derquinse.common.i18n.UnableToLocalizeException;

public final class LocalizedMessage
extends AbstractLocalized<String> {
    private static final Object[] EMPTY = new Object[0];
    private final Localized<String> pattern;
    private final Object[] args;
    private final boolean nested;

    public LocalizedMessage(Localized<String> pattern, Object ... args) {
        Preconditions.checkNotNull(pattern, (Object)"A message pattern must be provided");
        if (args == null) {
            this.args = EMPTY;
            this.nested = false;
        } else {
            boolean localized = false;
            for (Object o : args) {
                if (!(o instanceof Localized)) continue;
                localized = true;
                break;
            }
            this.args = args;
            this.nested = localized;
        }
        this.pattern = pattern;
    }

    @Override
    public String apply(Locale locale) {
        try {
            Object[] arguments;
            String text = this.pattern.apply(locale);
            if (this.args.length == 0) {
                return text;
            }
            if (this.nested) {
                arguments = new Object[this.args.length];
                for (int i = 0; i < this.args.length; ++i) {
                    Object o = this.args[i];
                    arguments[i] = o instanceof Localized ? ((Localized)o).apply(locale) : o;
                }
            } else {
                arguments = this.args;
            }
            return MessageFormat.format(text, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToLocalizeException(e);
        }
    }
}

