/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.i18n;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.derquinse.common.i18n.ForwardingLocalized;
import net.derquinse.common.i18n.L7d;
import net.derquinse.common.i18n.L7dString;
import net.derquinse.common.i18n.Locales;
import net.derquinse.common.i18n.Localized;
import net.derquinse.common.i18n.LocalizedBuilder;
import net.derquinse.common.i18n.UnableToLocalizeException;
import net.derquinse.common.i18n.Unlocalized;

public final class LocalizedValues {
    private LocalizedValues() {
        throw new AssertionError();
    }

    public static <T> Localized<T> fromMap(T defaultValue, @Nullable Map<? extends Locale, ? extends T> values) {
        if (values == null || values.isEmpty()) {
            return Unlocalized.of(defaultValue);
        }
        return LocalizedBuilder.create(defaultValue).putAll(values).build();
    }

    public static <T> Localized<T> fromStringMap(T defaultValue, @Nullable Map<String, ? extends T> values) {
        if (values == null || values.isEmpty()) {
            return Unlocalized.of(defaultValue);
        }
        LocalizedBuilder<T> builder = LocalizedBuilder.create(defaultValue);
        for (Map.Entry<String, T> entry : values.entrySet()) {
            builder.put(Locales.fromString(entry.getKey()), entry.getValue());
        }
        return builder.build();
    }

    public static Map<Locale, String> parse(Iterable<? extends L7d> values) {
        if (values == null) {
            return ImmutableMap.of();
        }
        HashMap map = Maps.newHashMap();
        for (L7d v : Iterables.filter(values, (Predicate)Predicates.notNull())) {
            map.put(Locales.fromString(v.locale()), v.value());
        }
        return map;
    }

    public static Map<Locale, String> parse(L7d ... values) {
        if (values == null || values.length == 0) {
            return ImmutableMap.of();
        }
        return LocalizedValues.parse(Arrays.asList(values));
    }

    public static Localized<String> parse(@Nullable L7dString value) {
        if (value == null) {
            return null;
        }
        return LocalizedValues.fromMap(value.value(), LocalizedValues.parse(value.values()));
    }

    private static <T> T get(Class<?> type, Object object, String method, Class<T> returnType, String error) {
        Object value;
        try {
            value = type.getMethod(method, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to get the %s parameter", error));
        }
        Preconditions.checkArgument((boolean)returnType.isInstance(value), (String)"Invalid type of the %s parameter", (Object[])new Object[]{error});
        return returnType.cast(value);
    }

    public static Localized<String> parse(Annotation annotation, String value, String values) {
        Preconditions.checkNotNull((Object)value, (Object)"The default value annotation parameter must be provided");
        Preconditions.checkNotNull((Object)value, (Object)"The localized values annotation parameter must be provided");
        if (annotation == null) {
            return null;
        }
        Class<? extends Annotation> type = annotation.annotationType();
        String defaultValue = LocalizedValues.get(type, annotation, value, String.class, "default value");
        L7d[] l7ds = LocalizedValues.get(type, annotation, values, L7d[].class, "localized values");
        return LocalizedValues.fromMap(defaultValue, LocalizedValues.parse(l7ds));
    }

    public static <T> Localized<T> withFallback(final Localized<T> value, final T fallback) {
        Preconditions.checkNotNull(value, (Object)"The localized value to wrap must be provided");
        Preconditions.checkNotNull(value, (Object)"The fallback value must be provided");
        return new ForwardingLocalized<T>(){

            @Override
            public T apply(Locale from) {
                try {
                    return this.delegate().apply(from);
                }
                catch (UnableToLocalizeException e) {
                    return fallback;
                }
            }

            @Override
            public T get() {
                try {
                    return this.delegate().get();
                }
                catch (UnableToLocalizeException e) {
                    return fallback;
                }
            }

            @Override
            protected Localized<T> delegate() {
                return value;
            }

            public String toString() {
                return String.format("Localized value [%s] with fallback [%s]", value, fallback);
            }
        };
    }
}

