/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.io;

import com.google.common.annotations.Beta;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.derquinse.common.base.NotInstantiable;

@Beta
public final class DurableFiles
extends NotInstantiable {
    private DurableFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputSupplier<? extends InputStream> from, File to) throws IOException {
        boolean threw = true;
        InputStream in = (InputStream)from.getInput();
        try {
            FileOutputStream os = new FileOutputStream(to);
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)os);
                os.flush();
                os.getFD().sync();
                threw = false;
            }
            finally {
                Closeables.close((Closeable)os, (boolean)threw);
            }
        }
        finally {
            Closeables.close((Closeable)in, (boolean)threw);
        }
    }

    public static void write(byte[] from, File to) throws IOException {
        DurableFiles.copy((InputSupplier<? extends InputStream>)ByteStreams.newInputStreamSupplier((byte[])from), to);
    }

    public static void copy(File from, File to) throws IOException {
        DurableFiles.copy((InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)from), to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> void copy(InputSupplier<R> from, File to, Charset charset) throws IOException {
        boolean threw = true;
        FileOutputStream os = new FileOutputStream(to);
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, charset);
            try {
                CharStreams.copy(from, (Appendable)w);
                w.flush();
                os.flush();
                os.getFD().sync();
                threw = false;
            }
            finally {
                Closeables.close((Closeable)w, (boolean)threw);
            }
        }
        finally {
            Closeables.close((Closeable)os, (boolean)threw);
        }
    }

    public static void write(CharSequence from, File to, Charset charset) throws IOException {
        DurableFiles.write(from, to, charset, false);
    }

    public static void append(CharSequence from, File to, Charset charset) throws IOException {
        DurableFiles.write(from, to, charset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(CharSequence from, File to, Charset charset, boolean append) throws IOException {
        boolean threw = true;
        FileOutputStream os = new FileOutputStream(to, append);
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, charset);
            try {
                w.append(from);
                w.flush();
                os.flush();
                os.getFD().sync();
                threw = false;
            }
            finally {
                Closeables.close((Closeable)w, (boolean)threw);
            }
        }
        finally {
            Closeables.close((Closeable)os, (boolean)threw);
        }
    }
}

