/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.log;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextLog {
    private final Logger logger;
    private final String context;

    public static ContextLog of(Logger logger) {
        return new ContextLog(logger);
    }

    public static ContextLog of(String name) {
        return new ContextLog(LoggerFactory.getLogger((String)name));
    }

    public static ContextLog of(Class<?> clazz) {
        return new ContextLog(LoggerFactory.getLogger(clazz));
    }

    private ContextLog(Logger logger) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (Object)"The source logger must be provided.");
        this.context = null;
    }

    private ContextLog(ContextLog parent, String context) {
        Preconditions.checkNotNull((Object)context, (Object)"The nested context must be provided.");
        this.logger = parent.logger;
        this.context = parent.context == null ? context : parent.context + '/' + context;
    }

    private String decorate(String msg, Object ... args) {
        boolean hasArgs;
        if (msg == null) {
            return null;
        }
        boolean bl = hasArgs = args != null && args.length > 0;
        if (this.context != null) {
            msg = new StringBuilder(this.context.length() + 2 + msg.length()).append(this.context).append(": ").append(msg).toString();
        }
        if (hasArgs) {
            return String.format(msg, args);
        }
        return msg;
    }

    public ContextLog to(@Nullable String context) {
        if (context == null || context.length() == 0) {
            return this;
        }
        return new ContextLog(this, context);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.decorate(msg, args));
        }
    }

    public void trace(Throwable t, String msg, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.decorate(msg, args), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.decorate(msg, args));
        }
    }

    public void debug(Throwable t, String msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.decorate(msg, args), t);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.decorate(msg, args));
        }
    }

    public void info(Throwable t, String msg, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.decorate(msg, args), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.decorate(msg, args));
        }
    }

    public void warn(Throwable t, String msg, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.decorate(msg, args), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.decorate(msg, args));
        }
    }

    public void error(Throwable t, String msg, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.decorate(msg, args), t);
        }
    }
}

