/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.meta;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import javax.annotation.Nullable;
import net.derquinse.common.base.MorePredicates;
import net.derquinse.common.meta.MetaFlag;
import net.derquinse.common.meta.MetaProperty;

public abstract class ComparableMetaProperty<C, T extends Comparable<T>>
extends MetaProperty<C, T> {
    public static final MetaFlag<ComparableMetaProperty<?, ?>> REQUIRED = new MetaFlag<ComparableMetaProperty<?, ?>>("required"){

        public boolean apply(ComparableMetaProperty<?, ?> input) {
            return input.isRequired();
        }
    };

    protected ComparableMetaProperty(String name, boolean required, @Nullable Predicate<? super T> validity, @Nullable T defaultValue) {
        super(name, required, validity, defaultValue);
    }

    protected ComparableMetaProperty(String name, boolean required, @Nullable Predicate<? super T> validity) {
        super(name, required, validity);
    }

    protected ComparableMetaProperty(String name, boolean required) {
        super(name, required);
    }

    public final Ordering<C> ordering() {
        return Ordering.natural().onResultOf((Function)this);
    }

    public final Predicate<C> greaterThan(T value) {
        return this.compose(MorePredicates.greaterThan(value));
    }

    public final Predicate<C> lessThan(T value) {
        return this.compose(MorePredicates.lessThan(value));
    }

    public final Predicate<C> greaterOrEqual(T value) {
        return this.compose(MorePredicates.greaterOrEqual(value));
    }

    public final Predicate<C> lessOrEqual(T value) {
        return this.compose(MorePredicates.lessOrEqual(value));
    }
}

