/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.meta;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import net.derquinse.common.meta.BooleanMetaProperty;
import net.derquinse.common.meta.Meta;

public abstract class MetaFlag<C>
extends Meta<C>
implements Predicate<C> {
    private final boolean defaultValue;

    protected MetaFlag(String name, boolean defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    protected MetaFlag(String name) {
        this(name, false);
    }

    public final boolean getDefaultValue() {
        return this.defaultValue;
    }

    public final BooleanMetaProperty<C> asProperty() {
        return new FlagProperty();
    }

    public final Predicate<C> not() {
        return Predicates.not((Predicate)this);
    }

    public final Predicate<C> and(Iterable<? extends Predicate<? super C>> components) {
        return Predicates.and((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)this), components));
    }

    public final Predicate<C> and(Predicate<? super C> ... components) {
        return this.and(Arrays.asList(components));
    }

    public final Predicate<C> and(Predicate<? super C> other) {
        return this.and((Iterable<? extends Predicate<? super C>>)ImmutableList.of(other));
    }

    public final Predicate<C> or(Iterable<? extends Predicate<? super C>> components) {
        return Predicates.or((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)this), components));
    }

    public final Predicate<C> or(Predicate<? super C> ... components) {
        return this.or(Arrays.asList(components));
    }

    public final Predicate<C> or(Predicate<? super C> other) {
        return this.or((Iterable<? extends Predicate<? super C>>)ImmutableList.of(other));
    }

    private final class FlagProperty
    extends BooleanMetaProperty<C> {
        FlagProperty() {
            super(MetaFlag.this.getName(), true, (Predicate<? super Boolean>)Predicates.alwaysTrue(), MetaFlag.this.defaultValue);
        }

        private MetaFlag<C> get() {
            return MetaFlag.this;
        }

        public Boolean apply(C input) {
            return this.get().apply(input);
        }

        public int hashCode() {
            return this.get().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FlagProperty) {
                return this.get() == ((FlagProperty)this.getClass().cast(obj)).get();
            }
            return false;
        }
    }
}

