/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.meta;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import javax.annotation.Nullable;
import net.derquinse.common.base.MorePredicates;
import net.derquinse.common.meta.Meta;
import net.derquinse.common.meta.MetaFlag;
import net.derquinse.common.meta.Metas;

public abstract class MetaProperty<C, T>
extends Meta<C>
implements Function<C, T> {
    public static final MetaFlag<MetaProperty<?, ?>> REQUIRED = new MetaFlag<MetaProperty<?, ?>>("required"){

        public boolean apply(MetaProperty<?, ?> input) {
            return input.isRequired();
        }
    };
    private final boolean required;
    private final Predicate<? super T> validity;
    private final T defaultValue;

    protected MetaProperty(String name, boolean required, @Nullable Predicate<? super T> validity, @Nullable T defaultValue) {
        super(name);
        this.required = required;
        this.validity = validity != null ? validity : Predicates.alwaysTrue();
        this.defaultValue = defaultValue;
    }

    protected MetaProperty(String name, boolean required, @Nullable Predicate<? super T> validity) {
        this(name, required, validity, null);
    }

    protected MetaProperty(String name, boolean required) {
        this(name, required, null);
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public final T checkValue(@Nullable T value) {
        if (value == null) {
            if (this.required) {
                throw new NullPointerException(String.format("Property [%s] does not allow null values", this.getName()));
            }
        } else if (!this.validity.apply(value)) {
            String msg = String.format("Illegal value [%s] for property [%s]", value.toString(), this.getName());
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public final boolean isValid(@Nullable T value) {
        try {
            this.checkValue(value);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private T getDefault() {
        if (this.required && this.defaultValue == null) {
            throw new IllegalStateException(String.format("No default value for required property [%s]", this.getName()));
        }
        return this.defaultValue;
    }

    public final T getDefaultIfNull(@Nullable T value) {
        if (value != null) {
            return value;
        }
        return this.getDefault();
    }

    public final T getDefaultIfInvalid(@Nullable T value) {
        if (this.isValid(value)) {
            return value;
        }
        return this.getDefault();
    }

    public final <V> Function<C, V> compose(Function<T, V> g) {
        return Functions.compose(g, (Function)this);
    }

    public final Predicate<C> compose(Predicate<? super T> predicate) {
        return Predicates.compose(predicate, (Function)this);
    }

    public final Predicate<C> isNull() {
        return this.compose(Predicates.isNull());
    }

    public final Predicate<C> notNull() {
        return this.compose(Predicates.notNull());
    }

    public final Predicate<C> equalTo(@Nullable T target) {
        return this.compose(Predicates.equalTo(target));
    }

    public final Predicate<C> sameAs(@Nullable T target) {
        return this.compose(MorePredicates.sameAs(target));
    }

    public final Predicate<C> instanceOf(Class<?> clazz) {
        return this.compose(Predicates.instanceOf(clazz));
    }

    public final Predicate<C> in(Collection<? extends T> target) {
        return this.compose(Predicates.in(target));
    }

    @Override
    public String toString() {
        Metas.ToStringHelper<MetaProperty<?, ?>> h = Metas.toStringHelper(this).add(NAME).add(REQUIRED);
        if (this.defaultValue != null) {
            h.add("defaultValue", this.defaultValue);
        }
        if (!Predicates.alwaysTrue().equals(this.validity)) {
            h.add("validity", this.validity);
        }
        return h.toString();
    }
}

