/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.meta;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.derquinse.common.base.NotInstantiable;
import net.derquinse.common.meta.MetaFlag;
import net.derquinse.common.meta.MetaProperty;

public final class Metas
extends NotInstantiable {
    private Metas() {
    }

    public static <C> ToStringHelper<C> toStringHelper(C self) {
        return new ToStringHelper(self);
    }

    public static final class ToStringHelper<C> {
        private final Objects.ToStringHelper helper;
        private final C object;

        private ToStringHelper(C object) {
            this.object = Preconditions.checkNotNull(object);
            this.helper = Objects.toStringHelper(object);
        }

        public ToStringHelper<C> add(String name, @Nullable Object value) {
            this.helper.add(name, value);
            return this;
        }

        public ToStringHelper<C> add(MetaProperty<? super C, ?> property) {
            this.helper.add(property.getName(), property.apply(this.object));
            return this;
        }

        public ToStringHelper<C> add(MetaFlag<? super C> flag) {
            this.helper.add(flag.getName(), flag.apply(this.object));
            return this;
        }

        public ToStringHelper<C> addValue(@Nullable Object value) {
            this.helper.addValue(value);
            return this;
        }

        public String toString() {
            return this.helper.toString();
        }
    }
}

