/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.reflect;

import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import net.derquinse.common.reflect.TypeDescriptor;
import net.derquinse.common.reflect.Types;

public class AbstractTypeDescriptor<T>
implements TypeDescriptor<T> {
    private final Type type;
    private final Class<? super T> rawType;

    protected AbstractTypeDescriptor() {
        this.type = Types.getSuperclassTypeArgument(this.getClass());
        this.rawType = Types.getRawType(this.type);
    }

    protected AbstractTypeDescriptor(Class<T> type) {
        this.type = (Type)Preconditions.checkNotNull(type, (Object)"The type must be provided");
        this.rawType = type;
    }

    @Override
    public final Type getType() {
        return this.type;
    }

    @Override
    public Class<? super T> getRawType() {
        return this.rawType;
    }

    @Override
    public final boolean isRawType() {
        return this.type == this.rawType;
    }
}

