/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.derquinse.common.base.NotInstantiable;

public final class Proxies
extends NotInstantiable {
    private Proxies() {
    }

    public static <T> T alwaysNull(Class<T> type) {
        return type.cast(Proxy.newProxyInstance(Proxies.class.getClassLoader(), new Class[]{type}, (InvocationHandler)AlwaysNull.INSTANCE));
    }

    public static Object alwaysNull(Class<?> ... interfaces) {
        return Proxy.newProxyInstance(Proxies.class.getClassLoader(), interfaces, (InvocationHandler)AlwaysNull.INSTANCE);
    }

    public static <T> T unsupported(Class<T> type) {
        return type.cast(Proxy.newProxyInstance(Proxies.class.getClassLoader(), new Class[]{type}, (InvocationHandler)Unsupported.INSTANCE));
    }

    public static Object unsupported(Class<?> ... interfaces) {
        return Proxy.newProxyInstance(Proxies.class.getClassLoader(), interfaces, (InvocationHandler)Unsupported.INSTANCE);
    }

    private static enum Unsupported implements InvocationHandler
    {
        INSTANCE;


        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "UnsupportedOperationException Proxy";
        }
    }

    private static enum AlwaysNull implements InvocationHandler
    {
        INSTANCE;


        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }

        public String toString() {
            return "Always NULL Proxy";
        }
    }
}

