/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.reflect;

import com.google.common.base.Preconditions;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.derquinse.common.base.NotInstantiable;
import net.derquinse.common.reflect.MoreTypes;

public final class Types
extends NotInstantiable {
    private Types() {
    }

    public static ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return Types.newParameterizedTypeWithOwner(null, rawType, typeArguments);
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        return new MoreTypes.ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new MoreTypes.GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        return new MoreTypes.WildcardTypeImpl(new Type[]{bound}, MoreTypes.EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        return new MoreTypes.WildcardTypeImpl(new Type[]{Object.class}, new Type[]{bound});
    }

    public static ParameterizedType listOf(Type elementType) {
        return Types.newParameterizedType(List.class, new Type[]{elementType});
    }

    public static ParameterizedType setOf(Type elementType) {
        return Types.newParameterizedType(Set.class, new Type[]{elementType});
    }

    public static ParameterizedType mapOf(Type keyType, Type valueType) {
        return Types.newParameterizedType(Map.class, new Type[]{keyType, valueType});
    }

    public static Type[] getSuperclassTypeArguments(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        Preconditions.checkArgument((boolean)(superclass instanceof ParameterizedType), (Object)"Missing type parameter.");
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments();
    }

    public static Type getSuperclassTypeArgument(Class<?> subclass) {
        return Types.getSuperclassTypeArguments(subclass)[0];
    }

    public static Class<?> getRawType(Type type) {
        return MoreTypes.getRawType(type);
    }
}

