/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.util.concurrent;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import net.derquinse.common.base.IntegerWaterMark;

public final class AtomicIntegerWaterMark {
    private final AtomicReference<IntegerWaterMark> ref;

    public static final AtomicIntegerWaterMark of(IntegerWaterMark initialValue) {
        return new AtomicIntegerWaterMark(initialValue);
    }

    public static final AtomicIntegerWaterMark of(int initialValue) {
        return AtomicIntegerWaterMark.of(IntegerWaterMark.of(initialValue));
    }

    public static final AtomicIntegerWaterMark of() {
        return AtomicIntegerWaterMark.of(0);
    }

    private AtomicIntegerWaterMark(IntegerWaterMark initialValue) {
        this.ref = Atomics.newReference((Object)Preconditions.checkNotNull((Object)initialValue, (Object)"Null initial values not allowed"));
    }

    public IntegerWaterMark get() {
        return this.ref.get();
    }

    public IntegerWaterMark set(int value) {
        IntegerWaterMark newValue;
        IntegerWaterMark current;
        do {
            if ((current = this.ref.get()) != (newValue = current.set(value))) continue;
            return current;
        } while (!this.ref.compareAndSet(current, newValue));
        return newValue;
    }

    public boolean compareAndSet(IntegerWaterMark expected, int value) {
        return this.ref.compareAndSet(expected, expected.set(value));
    }

    public boolean compareAndSet(int expected, int value) {
        IntegerWaterMark current = this.ref.get();
        if (current.get() == expected) {
            return this.compareAndSet(current, value);
        }
        return false;
    }

    public IntegerWaterMark add(int value) {
        IntegerWaterMark newValue;
        IntegerWaterMark current;
        while (!this.ref.compareAndSet(current = this.ref.get(), newValue = current.add(value))) {
        }
        return newValue;
    }

    public boolean compareAndAdd(IntegerWaterMark expected, int value) {
        return this.ref.compareAndSet(expected, expected.add(value));
    }

    public boolean compareAndAdd(int expected, int value) {
        IntegerWaterMark current = this.ref.get();
        if (current.get() == expected) {
            return this.compareAndAdd(current, value);
        }
        return false;
    }

    public IntegerWaterMark inc() {
        return this.add(1);
    }

    public IntegerWaterMark dec() {
        return this.add(-1);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.ref.get()).toString();
    }
}

