/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.util.concurrent;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import net.derquinse.common.base.LongWaterMark;

public final class AtomicLongWaterMark {
    private final AtomicReference<LongWaterMark> ref;

    public static final AtomicLongWaterMark of(LongWaterMark initialValue) {
        return new AtomicLongWaterMark(initialValue);
    }

    public static final AtomicLongWaterMark of(long initialValue) {
        return AtomicLongWaterMark.of(LongWaterMark.of(initialValue));
    }

    public static final AtomicLongWaterMark of() {
        return AtomicLongWaterMark.of(0L);
    }

    private AtomicLongWaterMark(LongWaterMark initialValue) {
        this.ref = Atomics.newReference((Object)Preconditions.checkNotNull((Object)initialValue, (Object)"Null initial values not allowed"));
    }

    public LongWaterMark get() {
        return this.ref.get();
    }

    public LongWaterMark set(long value) {
        LongWaterMark newValue;
        LongWaterMark current;
        do {
            if ((current = this.ref.get()) != (newValue = current.set(value))) continue;
            return current;
        } while (!this.ref.compareAndSet(current, newValue));
        return newValue;
    }

    public boolean compareAndSet(LongWaterMark expected, long value) {
        return this.ref.compareAndSet(expected, expected.set(value));
    }

    public boolean compareAndSet(int expected, long value) {
        LongWaterMark current = this.ref.get();
        if (current.get() == (long)expected) {
            return this.compareAndSet(current, value);
        }
        return false;
    }

    public LongWaterMark add(long value) {
        LongWaterMark newValue;
        LongWaterMark current;
        while (!this.ref.compareAndSet(current = this.ref.get(), newValue = current.add(value))) {
        }
        return newValue;
    }

    public boolean compareAndAdd(LongWaterMark expected, long value) {
        return this.ref.compareAndSet(expected, expected.add(value));
    }

    public boolean compareAndAdd(int expected, long value) {
        LongWaterMark current = this.ref.get();
        if (current.get() == (long)expected) {
            return this.compareAndAdd(current, value);
        }
        return false;
    }

    public LongWaterMark inc() {
        return this.add(1L);
    }

    public LongWaterMark dec() {
        return this.add(-1L);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.ref.get()).toString();
    }
}

