/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.util.concurrent;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.derquinse.common.base.Disposable;
import net.derquinse.common.base.IntegerWaterMark;
import net.derquinse.common.util.concurrent.RefCounted;

final class DefaultRefCounted<T>
implements RefCounted<T> {
    private final T value;
    private final AtomicReference<State> state;
    private final FutureTask<Long> task;
    private volatile Executor executor;

    DefaultRefCounted(T value, Runnable hook) {
        this.value = Preconditions.checkNotNull(value, (Object)"The referenced value is mandatory");
        this.state = Atomics.newReference((Object)new State());
        this.task = new FutureTask<Long>(new Hook(hook));
    }

    @Override
    public Disposable<T> get() {
        State next;
        State current;
        while (!this.state.compareAndSet(current = this.state.get(), next = current.inc())) {
        }
        return new RefDisposable(this.value);
    }

    @Override
    public int getCount() {
        return this.state.get().count();
    }

    @Override
    public int getMaxCount() {
        return this.state.get().max();
    }

    private void dec() {
        State next;
        State current;
        while (!this.state.compareAndSet(current = this.state.get(), next = current.dec())) {
        }
        this.runHook();
    }

    @Override
    public Future<Long> shutdown(Executor executor) {
        Preconditions.checkNotNull((Object)executor);
        while (!this.tryShutdown(executor)) {
        }
        return this.task;
    }

    public boolean tryShutdown(Executor executor) {
        State current = this.state.get();
        if (current.closed()) {
            return true;
        }
        this.executor = executor;
        State next = current.close();
        if (this.state.compareAndSet(current, next)) {
            this.runHook();
            return true;
        }
        return false;
    }

    @Override
    public Future<Long> shutdown() {
        return this.shutdown((Executor)MoreExecutors.sameThreadExecutor());
    }

    private void runHook() {
        State s = this.state.get();
        if (s.closed() && s.count() == 0) {
            this.executor.execute(this.task);
        }
    }

    public String toString() {
        State s = this.state.get();
        return Objects.toStringHelper((Object)this).add("value", this.value).add("active", !s.closed()).add("count", s.count()).add("max", s.max()).toString();
    }

    private static final class Hook
    implements Callable<Long> {
        private final Runnable hook;

        Hook(Runnable hook) {
            this.hook = (Runnable)Preconditions.checkNotNull((Object)hook, (Object)"The shutdown hook must be provided");
        }

        @Override
        public Long call() throws Exception {
            this.hook.run();
            return System.currentTimeMillis();
        }
    }

    private static class State {
        private final IntegerWaterMark count;
        private final boolean closed;

        State() {
            this.count = IntegerWaterMark.of();
            this.closed = false;
        }

        State(IntegerWaterMark count, boolean closed) {
            this.count = count;
            this.closed = closed;
        }

        void checkOpen() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed");
        }

        State close() {
            this.checkOpen();
            return new State(this.count, true);
        }

        boolean closed() {
            return this.closed;
        }

        int count() {
            return this.count.get();
        }

        int max() {
            return this.count.getMax();
        }

        State inc() {
            this.checkOpen();
            return new State(this.count.inc(), false);
        }

        State dec() {
            int current = this.count.get();
            Preconditions.checkState((current > 0 ? 1 : 0) != 0, (Object)"No reference to remove");
            return new State(this.count.dec(), this.closed);
        }
    }

    private final class RefDisposable
    implements Disposable<T> {
        private final AtomicBoolean disposed = new AtomicBoolean(false);

        RefDisposable(T value) {
        }

        @Override
        public T get() {
            Preconditions.checkState((!this.disposed.get() ? 1 : 0) != 0, (Object)"Reference already disposed");
            return DefaultRefCounted.this.value;
        }

        @Override
        public void dispose() {
            while (!this.disposed.get()) {
                if (!this.disposed.compareAndSet(false, true)) continue;
                DefaultRefCounted.this.dec();
            }
        }

        public String toString() {
            return String.format("%s{%s}", this.disposed.get() ? "Disposed" : "Disposable", DefaultRefCounted.this.value);
        }
    }
}

