/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.util.zip;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.derquinse.common.meta.MetaFlag;

public final class MaybeCompressed<T>
implements Serializable {
    private static final long serialVersionUID = -2115273664635743622L;
    public static final MetaFlag<MaybeCompressed<?>> COMPRESSED = new MetaFlag<MaybeCompressed<?>>("compressed"){

        public boolean apply(MaybeCompressed<?> input) {
            return input.isCompressed();
        }
    };
    private final boolean compressed;
    private final T payload;

    public static <T> MaybeCompressed<T> of(boolean compressed, T payload) {
        return new MaybeCompressed<T>(compressed, payload);
    }

    private MaybeCompressed(boolean compressed, T payload) {
        this.compressed = compressed;
        this.payload = Preconditions.checkNotNull(payload, (Object)"The payload must be provided");
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public T getPayload() {
        return this.payload;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.compressed, this.payload});
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaybeCompressed) {
            MaybeCompressed other = (MaybeCompressed)obj;
            return this.compressed == other.compressed && this.payload.equals(other.payload);
        }
        return false;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 4049913691759555221L;
        private final boolean compressed;
        private final T payload;

        public SerializationProxy(MaybeCompressed<T> m) {
            this.compressed = ((MaybeCompressed)m).compressed;
            this.payload = ((MaybeCompressed)m).payload;
        }

        private Object readResolve() {
            return MaybeCompressed.of(this.compressed, this.payload);
        }
    }
}

