/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.util.zip;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.derquinse.common.base.NotInstantiable;
import net.derquinse.common.util.zip.MaybeCompressed;

public final class ZipFiles
extends NotInstantiable {
    private ZipFiles() {
    }

    public static Map<String, byte[]> loadZip(InputStream input) throws IOException {
        ZipEntry entry;
        ImmutableMap.Builder b = ImmutableMap.builder();
        ZipInputStream zis = new ZipInputStream(input);
        while ((entry = zis.getNextEntry()) != null) {
            byte[] data = ByteStreams.toByteArray((InputStream)zis);
            String item = entry.getName();
            b.put((Object)item, (Object)data);
            zis.closeEntry();
        }
        return b.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> loadZip(InputSupplier<? extends InputStream> input) throws IOException {
        InputStream is = (InputStream)input.getInput();
        try {
            Map<String, byte[]> map = ZipFiles.loadZip(is);
            return map;
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] input) {
        ByteArrayInputStream is = new ByteArrayInputStream(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        try {
            GZIPOutputStream zos = new GZIPOutputStream(bos);
            try {
                ByteStreams.copy((InputStream)is, (OutputStream)zos);
            }
            finally {
                Closeables.closeQuietly((Closeable)zos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
        return bos.toByteArray();
    }

    public static Function<byte[], byte[]> gzip() {
        return Gzip.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gunzip(byte[] input) {
        ByteArrayInputStream is = new ByteArrayInputStream(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        try {
            GZIPInputStream zis = new GZIPInputStream(is);
            try {
                ByteStreams.copy((InputStream)zis, (OutputStream)bos);
            }
            finally {
                Closeables.closeQuietly((Closeable)zis);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)bos);
        }
        return bos.toByteArray();
    }

    public static Function<byte[], byte[]> gunzip() {
        return Gunzip.INSTANCE;
    }

    public static MaybeCompressed<byte[]> maybeGzip(byte[] input) {
        if (input.length <= 128) {
            return MaybeCompressed.of(false, input);
        }
        byte[] compressed = ZipFiles.gzip(input);
        if (compressed.length < input.length) {
            return MaybeCompressed.of(true, compressed);
        }
        return MaybeCompressed.of(false, input);
    }

    public static Function<byte[], MaybeCompressed<byte[]>> maybeGzip() throws IOException {
        return MaybeGzip.INSTANCE;
    }

    public static Map<String, byte[]> loadZip(File file) throws IOException {
        return ZipFiles.loadZip((InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)file));
    }

    public static Map<String, MaybeCompressed<byte[]>> loadZipAndGZip(InputStream input) throws IOException {
        Map<String, byte[]> loaded = ZipFiles.loadZip(input);
        return ImmutableMap.copyOf((Map)Maps.transformValues(loaded, ZipFiles.maybeGzip()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, MaybeCompressed<byte[]>> loadZipAndGZip(InputSupplier<? extends InputStream> input) throws IOException {
        InputStream is = (InputStream)input.getInput();
        try {
            Map<String, MaybeCompressed<byte[]>> map = ZipFiles.loadZipAndGZip(is);
            return map;
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
    }

    public static Map<String, MaybeCompressed<byte[]>> loadZipAndGZip(File file) throws IOException {
        return ZipFiles.loadZipAndGZip((InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)file));
    }

    private static enum MaybeGzip implements Function<byte[], MaybeCompressed<byte[]>>
    {
        INSTANCE;


        public MaybeCompressed<byte[]> apply(byte[] input) {
            return ZipFiles.maybeGzip(input);
        }
    }

    private static enum Gunzip implements Function<byte[], byte[]>
    {
        INSTANCE;


        public byte[] apply(byte[] input) {
            return ZipFiles.gunzip(input);
        }
    }

    private static enum Gzip implements Function<byte[], byte[]>
    {
        INSTANCE;


        public byte[] apply(byte[] input) {
            return ZipFiles.gzip(input);
        }
    }
}

