/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.uuid;

import java.security.SecureRandom;
import java.util.UUID;
import net.derquinse.common.uuid.SystemUUIDTimer;
import net.derquinse.common.uuid.UUIDGenerator;
import net.derquinse.common.uuid.UUIDTimer;

public final class TimeBasedUUIDGenerator
implements UUIDGenerator {
    private static final int MAX_SEQ = 16383;
    private static final long NODE_MASK = 0xFFFFFFFFFFFFL;
    private static final long MULTICAST = 0x100000000000L;
    private static final int MIN_NODE = 0;
    private static final int MAX_NODE = 47;
    private int sequence;
    private final UUIDTimer timer;
    private final long resolution;
    private long lastTime = 0L;
    private long lastSubtime = 0L;
    private final long node;
    private final long randomMask;
    private final SecureRandom random;

    public TimeBasedUUIDGenerator(UUIDTimer timer, long node, int bits) {
        if (timer == null) {
            timer = SystemUUIDTimer.INSTANCE;
        }
        SecureRandom sr = new SecureRandom();
        this.sequence = sr.nextInt(16383);
        this.timer = timer;
        this.resolution = timer.getResolution();
        bits = Math.max(0, bits);
        if ((bits = Math.min(47, bits)) == 47) {
            this.random = null;
            this.node = (node | 0x100000000000L) & 0xFFFFFFFFFFFFL;
            this.randomMask = 0L;
        } else {
            this.random = sr;
            if (bits == 0) {
                this.node = 0x100000000000L;
                this.randomMask = 0xFFFFFFFFFFFFL;
            } else {
                this.node = 0xFFFFFFFFFFFFL >>> 48 - bits & node | 0x100000000000L;
                this.randomMask = 0xFFFFFFFFFFFFL << bits & 0xFFFFFFFFFFFFL;
            }
        }
    }

    public TimeBasedUUIDGenerator(UUIDTimer timer) {
        this(timer, 0L, 0);
    }

    public TimeBasedUUIDGenerator(long node, int bits) {
        this(null, node, bits);
    }

    public TimeBasedUUIDGenerator() {
        this(null, 0L, 0);
    }

    private UUID build(long time, long node) {
        long hi = 4096L;
        hi |= time << 32;
        hi |= time >>> 16 & 0xFFFF0000L;
        long lo = Long.MIN_VALUE;
        lo |= (long)this.sequence << 48;
        return new UUID(hi |= time >>> 48 & 0xFFFL, lo |= node);
    }

    public UUID get() {
        long time = this.getTime(this.timer.getCurrentTime());
        long randomNode = this.random == null ? 0L : this.random.nextLong() & this.randomMask;
        return this.build(time, this.node | randomNode);
    }

    private synchronized long getTime(long current) {
        if (current > this.lastTime) {
            this.lastTime = current;
            this.lastSubtime = 0L;
        } else {
            ++this.lastSubtime;
            if (this.lastSubtime < this.resolution) {
                ++this.lastTime;
            } else {
                this.lastTime = current;
                this.lastSubtime = 0L;
                this.sequence = this.sequence + 1 & 0x3FFF;
            }
        }
        return this.lastTime;
    }
}

