/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.uuid;

import com.google.common.base.Function;
import java.util.UUID;
import net.derquinse.common.base.NotInstantiable;

public final class UUIDs
extends NotInstantiable {
    private UUIDs() {
    }

    public static Function<String, UUID> fromString() {
        return FromString.INSTANCE;
    }

    public static UUID safeFromString(String uuidString) {
        if (uuidString == null) {
            return null;
        }
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Function<String, UUID> safeFromString() {
        return SafeFromString.INSTANCE;
    }

    private static enum SafeFromString implements Function<String, UUID>
    {
        INSTANCE;


        public UUID apply(String from) {
            return UUIDs.safeFromString(from);
        }

        public String toString() {
            return "UUIDs.safeFromString";
        }
    }

    private static enum FromString implements Function<String, UUID>
    {
        INSTANCE;


        public UUID apply(String from) {
            return UUID.fromString(from);
        }

        public String toString() {
            return "UUIDs.fromString";
        }
    }
}

