/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.common.security;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.core.io.Resource;

public final class KeyStoreUtils {
    public static final String FORMAT_AUTODETECT = "AUTODETECT";
    public static final String FORMAT_FALLBACK = KeyStore.getDefaultType();
    private static final Map<String, String> FORMAT_MAPPING = ImmutableMap.builder().put((Object)"jks", (Object)"JKS").put((Object)"p12", (Object)"PKCS12").put((Object)"pfx", (Object)"PKCS12").build();

    public static String detectFormat(String format, String name) {
        if (FORMAT_AUTODETECT.equals(format)) {
            if (name == null) {
                return FORMAT_FALLBACK;
            }
            int index = name.lastIndexOf(46);
            if (index == -1) {
                return FORMAT_FALLBACK;
            }
            String ending = name.substring(index + 1).toLowerCase();
            return FORMAT_MAPPING.getOrDefault(ending, FORMAT_FALLBACK);
        }
        return format;
    }

    public static KeyManagerFactory loadKeyManagerFactory(String keyStoreFormat, Resource keyStore, String keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore ks = KeyStoreUtils.loadKeyStore(keyStoreFormat, keyStore, keyStorePassword);
        String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        keyManagerFactory.init(ks, KeyStoreUtils.keystorePassword(keyStorePassword));
        return keyManagerFactory;
    }

    public static TrustManagerFactory loadTrustManagerFactory(String trustStoreFormat, Resource trustStore, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStoreUtils.loadKeyStore(trustStoreFormat, trustStore, trustStorePassword);
        String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        trustManagerFactory.init(ks);
        return trustManagerFactory;
    }

    private static KeyStore loadKeyStore(String keyStoreFormat, Resource keyStore, String keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Objects.requireNonNull(keyStoreFormat, "keyStoreFormat");
        Objects.requireNonNull(keyStore, "keyStore");
        String detectedFormat = KeyStoreUtils.detectFormat(keyStoreFormat, keyStore.getFilename());
        KeyStore ks = KeyStore.getInstance(detectedFormat);
        try (InputStream stream = keyStore.getInputStream();){
            ks.load(stream, KeyStoreUtils.keystorePassword(keyStorePassword));
        }
        return ks;
    }

    private static char[] keystorePassword(String password) {
        if (password == null) {
            return new char[0];
        }
        return password.toCharArray();
    }

    private KeyStoreUtils() {
    }
}

