/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.d3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.diversionmc.d3.Storage;
import net.diversionmc.d3.operation.Group;
import net.diversionmc.d3.operation.GroupClose;
import net.diversionmc.d3.operation.GroupOpen;
import net.diversionmc.d3.operation.IndexClose;
import net.diversionmc.d3.operation.IndexGroup;
import net.diversionmc.d3.operation.IndexOpen;
import net.diversionmc.d3.operation.OPArithmetic;
import net.diversionmc.d3.operation.OPIndex;
import net.diversionmc.d3.operation.Operation;
import net.diversionmc.d3.operation.Operator;
import net.diversionmc.d3.operation.VString;
import net.diversionmc.d3.structure.D3SLevel;
import net.diversionmc.d3.structure.D3SMacro;
import net.diversionmc.d3.structure.D3SValue;
import net.diversionmc.d3.structure.D3Sentence;
import net.diversionmc.d3.structure.LevelEnd;
import net.diversionmc.d3.structure.LevelGroup;
import net.diversionmc.d3.structure.LevelStart;
import net.diversionmc.d3.structure.ListEnd;
import net.diversionmc.d3.structure.ListGroup;
import net.diversionmc.d3.structure.ListStart;
import net.diversionmc.d3.structure.Path;
import net.diversionmc.d3.structure.Value;
import net.diversionmc.parser.Parser;
import net.diversionmc.parser.expression.NamePiece;
import net.diversionmc.parser.expression.NumberPiece;
import net.diversionmc.parser.expression.StringPiece;
import net.diversionmc.parser.pattern.ParsePattern;
import net.diversionmc.parser.pattern.PatternResult;
import net.diversionmc.parser.pattern.Sentence;
import net.diversionmc.parser.util.ParserException;
import net.diversionmc.parser.util.Pointable;

public class D3
extends Storage {
    private final File physical;
    private long lastModified;
    private final Parser<D3Sentence> structureParser;
    private final Parser<Operation> valueParser;
    private String currentLevel = "";
    private final Map<String, UnaryOperator<String>> macros = new LinkedHashMap<String, UnaryOperator<String>>(Map.ofEntries(Map.entry("pi", s -> "3.141592653589793"), Map.entry("sin", s -> "" + Math.sin(NumberPiece.tryNumber((String)s))), Map.entry("cos", s -> "" + Math.cos(NumberPiece.tryNumber((String)s))), Map.entry("sqrt", s -> "" + Math.sqrt(NumberPiece.tryNumber((String)s))), Map.entry("abs", s -> "" + Math.abs(NumberPiece.tryNumber((String)s))), Map.entry("floor", s -> "" + Math.floor(NumberPiece.tryNumber((String)s))), Map.entry("ceil", s -> "" + Math.ceil(NumberPiece.tryNumber((String)s))), Map.entry("round", s -> "" + Math.round(NumberPiece.tryNumber((String)s))), Map.entry("sum", s -> "" + Arrays.stream(s.split("\n")).mapToDouble(NumberPiece::tryNumber).sum()), Map.entry("mul", s -> "" + Arrays.stream(s.split("\n")).mapToDouble(NumberPiece::tryNumber).reduce((a, b) -> a * b).orElseThrow(NumberFormatException::new)), Map.entry("len", s -> "" + s.length()), Map.entry("cut", s -> {
        String[] args = s.split("\n");
        s = args[0];
        if (args.length > 1) {
            Double n1 = NumberPiece.tryNumber((String)args[1]);
            if (args.length > 2) {
                Double n2 = NumberPiece.tryNumber((String)args[2]);
                if (n1 >= 0.0 && n2 <= (double)s.length() && n1 <= n2) {
                    return s.substring(n1.intValue(), n2.intValue());
                }
            } else if (n1 <= (double)s.length()) {
                return s.substring(0, n1.intValue());
            }
        }
        return s;
    }), Map.entry("from", s -> {
        Double n1;
        String[] args = s.split("\n");
        s = args[0];
        if (args.length > 1 && (n1 = NumberPiece.tryNumber((String)args[1])) >= 0.0 && n1 <= (double)s.length()) {
            return s.substring(n1.intValue());
        }
        return s;
    }), Map.entry("index", s -> {
        String[] args = s.split("\n");
        return "" + args[0].indexOf(args[1]);
    }), Map.entry("at", s -> {
        String[] args = s.split("\n");
        Double n1 = NumberPiece.tryNumber((String)args[1]);
        return "" + args[0].charAt(n1.intValue());
    }), Map.entry("repeat", s -> {
        String[] args = s.split("\n");
        Double n1 = NumberPiece.tryNumber((String)args[1]);
        return args[0].repeat(n1.intValue());
    }), Map.entry("count", s -> {
        String[] args = s.split("\n");
        return args[1].isEmpty() ? "" + (args[0].length() + 1) : "" + (args[0].length() - args[0].replace(args[1], "").length()) / args[1].length();
    }), Map.entry("concat", s -> s.replace("\n", "")), Map.entry("n", s -> "\n"), Map.entry("size", s -> "" + s.split("\n").length), Map.entry("distinct", s -> Arrays.stream(s.split("\n")).distinct().collect(Collectors.joining("\n"))), Map.entry("filter", s -> {
        String[] args = s.split("\n");
        String macro = args[args.length - 1];
        return Arrays.stream(args).limit(args.length - 1).filter(e -> NumberPiece.tryBoolean((String)((String)this.macro(macro).apply((String)e)))).collect(Collectors.joining("\n"));
    }), Map.entry("map", s -> {
        String[] args = s.split("\n");
        String macro = args[args.length - 1];
        return Arrays.stream(args).limit(args.length - 1).map(e -> (String)this.macro(macro).apply((String)e)).collect(Collectors.joining("\n"));
    }), Map.entry("reduce", s -> {
        String[] args = s.split("\n");
        String macro = args[args.length - 1];
        return Arrays.stream(args).limit(args.length - 1).reduce((a, e) -> (String)this.macro(macro).apply(a + "\n" + e)).orElse(null);
    }), Map.entry("currentLevel", s -> this.currentLevel), Map.entry("exists", s -> "" + this.exists(s)), Map.entry("orElse", s -> {
        String[] args = s.split("\n");
        return NumberPiece.tryBoolean((String)args[0]) ? args[1] : args[2];
    })));

    public D3(File f) {
        this.structureParser = Parser.parser();
        this.valueParser = Parser.parser();
        AtomicBoolean inList = new AtomicBoolean();
        AtomicBoolean afterPath = new AtomicBoolean();
        this.structureParser.pre(() -> {
            inList.set(false);
            afterPath.set(false);
        }).piece((c, ptr) -> inList.get() || afterPath.get() ? new Value(ptr, inList.get()) : new Path(ptr)).pieceFinish(e -> {
            if (e instanceof ListStart) {
                inList.set(true);
            }
            if (e instanceof ListEnd) {
                inList.set(false);
            }
            afterPath.set(e instanceof Path);
        }).group(e -> e instanceof LevelStart, e -> e instanceof LevelEnd, (left, right, content) -> new LevelGroup(left.pointer(), content, left.path())).group(e -> e instanceof ListStart, e -> e instanceof ListEnd, (left, right, content) -> new ListGroup(left.pointer(), content, left.path())).pattern("level", e -> {
            Object level$temp = e.get(0);
            if (!(level$temp instanceof LevelGroup)) {
                return null;
            }
            LevelGroup level = (LevelGroup)((Object)((Object)level$temp));
            LinkedList res = ParsePattern.match((List)level.content(), (ParsePattern[])this.structureParser.patterns());
            return new PatternResult(1, (Sentence)new D3SLevel(level.pointer(), level.path(), res));
        }).pattern("list", e -> {
            Object list$temp = e.get(0);
            if (!(list$temp instanceof ListGroup)) {
                return null;
            }
            ListGroup list = (ListGroup)((Object)((Object)list$temp));
            e = list.content();
            StringBuilder res = new StringBuilder();
            int limit = e.size();
            for (int i = 0; i < limit; ++i) {
                Object v$temp = e.get(i);
                if (!(v$temp instanceof Value)) {
                    return null;
                }
                Value v = (Value)((Object)((Object)v$temp));
                if (i > 0) {
                    res.append('\n');
                }
                res.append(v.value());
            }
            return new PatternResult(1, (Sentence)new D3SValue(list.pointer(), list.path(), res.toString()));
        }).pattern("pair", e -> {
            Object k$temp = e.get(0);
            if (!(k$temp instanceof Path)) {
                return null;
            }
            Path k = (Path)((Object)((Object)k$temp));
            Object v$temp = e.get(1);
            if (!(v$temp instanceof Value)) {
                return null;
            }
            Value v = (Value)((Object)((Object)v$temp));
            return new PatternResult(2, (Sentence)new D3SValue(k.pointer(), k.path(), v.value()));
        });
        ParsePattern STRING = e -> {
            Object str$temp = e.get(0);
            if (!(str$temp instanceof StringPiece)) {
                return null;
            }
            StringPiece str = (StringPiece)str$temp;
            return new PatternResult(1, (Sentence)new VString(str.pointer(), str.content()));
        };
        ParsePattern NUMBER = e -> {
            Object n$temp = e.get(0);
            if (!(n$temp instanceof NamePiece)) {
                return null;
            }
            NamePiece n = (NamePiece)n$temp;
            Double num = NumberPiece.tryNumber((String)n.name());
            if (num == null) {
                return null;
            }
            return new PatternResult(1, (Sentence)new VString(n.pointer(), n.name()));
        };
        ParsePattern GROUP = e -> {
            Object group$temp = e.get(0);
            if (!(group$temp instanceof Group)) {
                return null;
            }
            Group group = (Group)((Object)((Object)group$temp));
            e = group.content();
            int limit = e.size();
            PatternResult v = ParsePattern.matchOne((List)e, (ParsePattern[])new ParsePattern[]{this.valueParser.pattern("operation")});
            if (v == null || v.length() < limit) {
                return null;
            }
            return new PatternResult(1, (Sentence)((Operation)v.result()));
        };
        ParsePattern MACRO = e -> {
            if (e.size() < 2) {
                return null;
            }
            Object n$temp = e.get(0);
            if (!(n$temp instanceof NamePiece)) {
                return null;
            }
            NamePiece n = (NamePiece)n$temp;
            Object g$temp = e.get(1);
            if (!(g$temp instanceof Group)) {
                return null;
            }
            Group g = (Group)((Object)((Object)g$temp));
            UnaryOperator macro = this.paths(n.name()).stream().map(this.macros::get).filter(Objects::nonNull).findFirst().orElse(null);
            if (macro == null) {
                return null;
            }
            e = g.content();
            int limit = e.size();
            if (limit == 0) {
                return null;
            }
            PatternResult v = this.valueParser.pattern("operation").parse(e);
            if (v.length() < limit) {
                return null;
            }
            Operation r = (Operation)v.result();
            if (r == null) {
                return null;
            }
            return new PatternResult(2, (Sentence)new VString(n.pointer(), (String)macro.apply(r.result())));
        };
        ParsePattern PATH = e -> {
            Object n$temp = e.get(0);
            if (!(n$temp instanceof NamePiece)) {
                return null;
            }
            NamePiece n = (NamePiece)n$temp;
            String v = this.getString(n.name());
            if (v == null) {
                return null;
            }
            return new PatternResult(1, (Sentence)new VString(n.pointer(), v));
        };
        ParsePattern VALUE = e -> {
            Object i$temp;
            Object op$temp;
            int pos = 0;
            int limit = e.size();
            LinkedList<Operator> unary = new LinkedList<Operator>();
            while ((op$temp = e.get(pos)) instanceof Operator) {
                Operator op = (Operator)((Object)((Object)op$temp));
                if (++pos == limit) {
                    return null;
                }
                if (op.type() != Operator.OperatorType.ADD && op.type() != Operator.OperatorType.SUB && op.type() != Operator.OperatorType.NOT) {
                    return null;
                }
                if (op.type() == Operator.OperatorType.ADD) continue;
                if (op.type() == Operator.OperatorType.SUB) {
                    op.type(Operator.OperatorType.UMS);
                }
                unary.push(op);
            }
            PatternResult value = ParsePattern.matchOne(e.subList(pos, limit), (ParsePattern[])new ParsePattern[]{STRING, NUMBER, GROUP, MACRO, PATH});
            if (value == null) {
                return null;
            }
            Operation res = (Operation)value.result();
            if ((pos += value.length()) < limit && (i$temp = e.get(pos)) instanceof IndexGroup) {
                IndexGroup i = (IndexGroup)((Object)((Object)i$temp));
                ++pos;
                e = i.content();
                limit = e.size();
                PatternResult v = this.valueParser.pattern("operation").parse(e);
                if (v.length() < limit) {
                    return null;
                }
                Operation r = (Operation)v.result();
                if (r == null) {
                    return null;
                }
                Double index = NumberPiece.tryNumber((String)r.result());
                if (index == null) {
                    return null;
                }
                res = new OPIndex(r.pointer(), res, index.intValue());
            }
            for (Operator op : unary) {
                res = new OPArithmetic(op.pointer(), op.type(), res, null);
            }
            return new PatternResult(pos, (Sentence)res);
        };
        this.valueParser.piece((c, ptr) -> c == '(', (c, ptr) -> new GroupOpen(ptr)).piece((c, ptr) -> c == ')', (c, ptr) -> new GroupClose(ptr)).piece((c, ptr) -> c == '[', (c, ptr) -> new IndexOpen(ptr)).piece((c, ptr) -> c == ']', (c, ptr) -> new IndexClose(ptr)).piece((c, ptr) -> c == '\"' || c == '\'', (c, ptr) -> new StringPiece(ptr, c)).piece((c, ptr) -> Operator.check(c), (c, ptr) -> new Operator(ptr)).piece((c, ptr) -> NamePiece.check((char)c, (String)"_$."), (c, ptr) -> new NamePiece(ptr, "_$.")).group(e -> e instanceof GroupOpen, e -> e instanceof GroupClose, (left, right, content) -> new Group(left.pointer(), content)).group(e -> e instanceof IndexOpen, e -> e instanceof IndexClose, (left, right, content) -> new IndexGroup(left.pointer(), content)).pattern("singlePrimitive", e -> {
            if (e.size() != 1) {
                return null;
            }
            return ParsePattern.matchOne((List)e, (ParsePattern[])new ParsePattern[]{STRING, NUMBER});
        }).pattern("operation", e -> {
            int pos = 0;
            int limit = e.size();
            if (pos == limit) {
                return null;
            }
            LinkedList<Object> res = new LinkedList<Object>();
            while (pos < limit) {
                PatternResult v = ParsePattern.matchOne(e.subList(pos, limit), (ParsePattern[])new ParsePattern[]{VALUE});
                if (v == null) {
                    return null;
                }
                Operation r = (Operation)v.result();
                if (r == null) {
                    return null;
                }
                res.add((Object)new VString(r.pointer(), r.result()));
                if ((pos += v.length()) >= limit) continue;
                Object op$temp = e.get(pos);
                if (!(op$temp instanceof Operator)) {
                    return null;
                }
                Operator op = (Operator)((Object)((Object)op$temp));
                res.add((Object)op);
            }
            Operator.solvers.forEach(s -> s.solve((List)res));
            ParserException.ASSERT((res.size() == 1 ? 1 : 0) != 0, () -> ((Pointable)res.get(1)).pointer(), (String)"Operation did not give a single result");
            return new PatternResult(pos, (Sentence)((Operation)((Object)((Object)res.get(0)))));
        });
        this.physical = f;
        if (this.physical != null) {
            this.reload();
        }
    }

    public D3(String text) {
        this((File)null);
        this.structureParser.text(text).build().stream().flatMap(s -> s.values(this).stream()).forEach(s -> this.appendValue("", (D3SValue)((Object)s)));
    }

    public D3(InputStream is) {
        this((File)null);
        try {
            this.structureParser.readFrom(is).build().stream().flatMap(s -> s.values(this).stream()).forEach(s -> this.appendValue("", (D3SValue)((Object)s)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load from stream", e);
        }
    }

    private void appendValue(String pathTo, D3SValue v) {
        D3SValue d3SValue;
        if (!((String)pathTo).isEmpty()) {
            pathTo = (String)pathTo + ".";
        }
        if ((d3SValue = v) instanceof D3SMacro) {
            D3SMacro m = (D3SMacro)d3SValue;
            this.appendMacro((String)pathTo, m);
            return;
        }
        String path = (String)pathTo + v.path();
        String value = v.value();
        int pos = path.lastIndexOf(46);
        String old = this.currentLevel;
        this.currentLevel = path.substring(0, Math.max(0, pos));
        this.set(path.substring(pos + 1), this.evaluate(value));
        this.currentLevel = old;
    }

    private void appendMacro(String pathTo, D3SMacro m) {
        String path = pathTo + m.path();
        this.macro(path, s -> {
            String old = this.currentLevel;
            this.currentLevel = path + "()";
            this.set(this.currentLevel + ".input", s);
            m.items().stream().flatMap(s1 -> s1.values(this).stream()).forEach(s1 -> this.appendValue(this.currentLevel, (D3SValue)((Object)((Object)s1))));
            String res = this.evaluate("return");
            this.removeLevel(new Object[0]);
            this.currentLevel = old;
            return res;
        });
    }

    @Override
    protected String path(Object ... path) {
        String level = super.path(path);
        return !this.currentLevel.isEmpty() ? (level.isEmpty() ? this.currentLevel : this.currentLevel + "." + level) : level;
    }

    @Override
    protected List<String> paths(Object ... path) {
        String level = super.path(path);
        LinkedList<String> res = new LinkedList<String>();
        String c = this.currentLevel;
        while (!c.isEmpty()) {
            res.add((String)(level.isEmpty() ? c : c + "." + level));
            int pos = c.lastIndexOf(46);
            c = pos <= 0 ? "" : c.substring(0, pos);
        }
        res.add(level);
        return res;
    }

    @Override
    public D3 set(Object ... pathAndValue) {
        return (D3)super.set(pathAndValue);
    }

    @Override
    public D3 set(boolean overwrite, Object ... pathAndValue) {
        return (D3)super.set(overwrite, pathAndValue);
    }

    @Override
    public D3 remove(Object ... path) {
        return (D3)super.remove(path);
    }

    @Override
    public D3 removeLevel(Object ... path) {
        return (D3)super.removeLevel(path);
    }

    @Override
    public D3 reorder() {
        return (D3)super.reorder();
    }

    @Override
    public D3 backup(Storage backup) {
        return (D3)super.backup(backup);
    }

    @Override
    public D3 backupInsert(Storage chain) {
        return (D3)super.backupInsert(chain);
    }

    @Override
    public D3 backupAppend(Storage chain) {
        return (D3)super.backupAppend(chain);
    }

    @Override
    public D3 backupLossy(Storage backup) {
        return (D3)super.backupLossy(backup);
    }

    public String evaluate(String input) {
        try {
            String res = ((Operation)((Object)this.valueParser.text(input).build().get(0))).result();
            Double num = NumberPiece.tryNumber((String)res);
            if (num != null && res.endsWith(".0")) {
                return "" + num.longValue();
            }
            return res;
        }
        catch (Exception exception) {
            return input;
        }
    }

    public UnaryOperator<String> macro(String macro) {
        return this.macros.get(macro);
    }

    public D3 macro(String macro, UnaryOperator<String> f) {
        ParserException.ASSERT((macro != null ? 1 : 0) != 0, (String)"Macro name is null");
        ParserException.ASSERT((f != null ? 1 : 0) != 0, (String)("Macro " + macro + " is null"));
        this.macros.put(macro, f);
        return this;
    }

    public String toString() {
        return this.toString(PrintStyle.COMPACT);
    }

    public String toString(PrintStyle style) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        style.print(this, new PrintWriter(os, true));
        return os.toString();
    }

    public D3 save() {
        return this.save(PrintStyle.COMPACT);
    }

    public D3 save(PrintStyle style) {
        if (this.physical == null) {
            throw new IllegalArgumentException("Cannot save a D3 made without a file");
        }
        Storage backup = this.backup();
        this.backup(null);
        try (FileOutputStream f = new FileOutputStream(this.physical);
             FileLock ignored = f.getChannel().lock();){
            style.print(this, new PrintWriter(f, true));
            this.lastModified = this.physical.lastModified();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot save file " + this.physical, e);
        }
        finally {
            this.backup(backup);
        }
        return this;
    }

    public D3 reload() {
        if (this.physical == null) {
            throw new IllegalArgumentException("Cannot reload a D3 made without a file");
        }
        try {
            Stream res = this.structureParser.readFrom(this.physical).build().stream().flatMap(s -> s.values(this).stream());
            this.removeLevel(new Object[0]);
            res.forEach(s -> this.appendValue("", (D3SValue)((Object)s)));
            this.lastModified = this.physical.lastModified();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load file " + this.physical, e);
        }
        return this;
    }

    public D3 reloadIfModified() {
        if (this.physical == null) {
            throw new IllegalArgumentException("Cannot reload a D3 made without a file");
        }
        return this.physical.isFile() && this.physical.lastModified() > this.lastModified ? this.reload() : this;
    }

    public static enum PrintStyle {
        COMPACT{

            @Override
            public void print(D3 d3, PrintWriter out) {
                this.parseCompact(d3, out, "", new LinkedList<Map.Entry<String, String>>(d3.getValuesDeep(new Object[0]).entrySet()));
            }

            private void parseCompact(D3 d3, PrintWriter out, String spaces, List<Map.Entry<String, String>> lines) {
                if (lines.isEmpty()) {
                    return;
                }
                int pos = 0;
                int limit = lines.size();
                LinkedList<String> currentCommon = new LinkedList<String>();
                for (int i = 0; i < limit; ++i) {
                    List<String> path = Arrays.asList(lines.get(i).getKey().split("\\."));
                    if (i == 0) {
                        currentCommon.addAll(path);
                        continue;
                    }
                    List<String> newCommon = this.findCommon(path, currentCommon);
                    if (newCommon.isEmpty()) {
                        this.printLevel(d3, out, spaces, currentCommon, lines.subList(pos, i));
                        pos = i;
                        currentCommon.clear();
                        currentCommon.addAll(path);
                        continue;
                    }
                    currentCommon.clear();
                    currentCommon.addAll(newCommon);
                }
                this.printLevel(d3, out, spaces, currentCommon, lines.subList(pos, limit));
            }

            private void printLevel(D3 d3, PrintWriter out, String spaces, List<String> currentCommon, List<Map.Entry<String, String>> lines) {
                if (lines.size() > 1) {
                    String level = String.join((CharSequence)".", currentCommon);
                    out.println(spaces + level);
                    this.parseCompact(d3, out, spaces + "  ", lines.stream().map(e -> Map.entry(((String)e.getKey()).substring(level.length() + 1), (String)e.getValue())).collect(Collectors.toList()));
                    out.println(spaces + "<");
                } else {
                    PrintStyle.printValue(d3, out, spaces, lines.get(0));
                }
            }

            private <E> List<E> findCommon(List<E> a, List<E> b) {
                int pos = -1;
                int limit = Math.min(a.size(), b.size());
                ArrayList<E> res = new ArrayList<E>(limit);
                while (++pos < limit) {
                    E v = a.get(pos);
                    if (!a.get(pos).equals(b.get(pos))) break;
                    res.add(v);
                }
                return res;
            }
        }
        ,
        TREE{

            @Override
            public void print(D3 d3, PrintWriter out) {
                this.parseTree(d3, out, "", new LinkedList<Map.Entry<String, String>>(d3.getValuesDeep(new Object[0]).entrySet()));
            }

            private void parseTree(D3 d3, PrintWriter out, String spaces, List<Map.Entry<String, String>> lines) {
                LinkedList<Map.Entry<String, String>> entries = new LinkedList<Map.Entry<String, String>>();
                String lastLevel = null;
                for (Map.Entry<String, String> line : lines) {
                    String key = line.getKey();
                    int pos = key.indexOf(46);
                    String level = key.substring(0, Math.max(0, pos));
                    if (lastLevel == null) {
                        lastLevel = level;
                    } else if (!lastLevel.equals(level)) {
                        this.printLevel(d3, out, spaces, lastLevel, entries);
                        entries.clear();
                        lastLevel = level;
                    }
                    entries.add(Map.entry(key.substring(pos + 1), line.getValue()));
                }
                if (entries.size() > 0) {
                    this.printLevel(d3, out, spaces, lastLevel, entries);
                }
            }

            private void printLevel(D3 d3, PrintWriter out, String spaces, String level, List<Map.Entry<String, String>> entries) {
                if (level.isEmpty()) {
                    entries.forEach(l -> PrintStyle.printValue(d3, out, spaces, l));
                } else {
                    out.println(spaces + level);
                    this.parseTree(d3, out, spaces + "  ", entries);
                    out.println(spaces + "<");
                }
            }
        }
        ,
        CLEAR{

            @Override
            public void print(D3 d3, PrintWriter out) {
                d3.getValuesDeep(new Object[0]).entrySet().forEach(e -> PrintStyle.printValue(d3, out, "", e));
            }
        };


        private static void printValue(D3 d3, PrintWriter out, String spaces, Map.Entry<String, String> entry) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.contains("\n")) {
                out.println(spaces + key + "[");
                for (String line : value.split("\n")) {
                    out.println(spaces + "  " + PrintStyle.escape(d3, line));
                }
                out.println(spaces + "]");
            } else {
                out.println(spaces + key + " " + PrintStyle.escape(d3, value));
            }
        }

        private static String escape(D3 d3, String s) {
            return !d3.evaluate(s).equals(s) || s.contains("//") || s.contains("/*") || s.startsWith(" ") || s.endsWith(" ") ? "\"" + StringPiece.escape((CharSequence)s) + "\"" : s;
        }

        public abstract void print(D3 var1, PrintWriter var2);
    }
}

