/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.diversionmc.d3.StoragePath;

public class Storage {
    private final Map<String, String> values = new LinkedHashMap<String, String>();
    private Storage backup;

    protected String path(Object ... path) {
        return Arrays.stream(path).map(p -> Objects.toString(p).replace(' ', '.')).collect(Collectors.joining("."));
    }

    protected List<String> paths(Object ... path) {
        return List.of(this.path(path));
    }

    public boolean exists(Object ... path) {
        return this.paths(path).stream().anyMatch(this.values::containsKey);
    }

    public String getString(Object ... path) {
        return this.paths(path).stream().map(this.values::get).filter(Objects::nonNull).findFirst().orElseGet(() -> this.backup == null ? null : this.backup.getString(path));
    }

    public List<String> getStringList(Object ... path) {
        String string = this.getString(path);
        return string != null ? Arrays.asList(string.split("\n")) : new ArrayList();
    }

    public StoragePath get(Object ... path) {
        return new StoragePath(this, path);
    }

    public List<StoragePath> levels(Object ... path) {
        return this.getLevels(path).stream().map(level -> this.get(Stream.of(Stream.of(path), Stream.of(level)).flatMap(s -> s).toArray())).collect(Collectors.toList());
    }

    public List<String> getLevels(Object ... path) {
        String level = this.path(path);
        List<String> res = this.values.keySet().stream().filter(key -> level.isEmpty() || key.startsWith(level + ".")).map(key -> key.substring(level.isEmpty() ? 0 : level.length() + 1)).filter(key -> key.contains(".")).map(key -> key.substring(0, key.indexOf(46))).distinct().collect(Collectors.toList());
        if (this.backup != null) {
            this.backup.getLevels(path).stream().filter(l -> !res.contains(l)).forEach(res::add);
        }
        return res;
    }

    public Map<String, String> getValues(Object ... path) {
        String level = this.path(path);
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        this.values.entrySet().stream().filter(e -> level.isEmpty() || ((String)e.getKey()).startsWith(level + ".")).map(e -> Map.entry(((String)e.getKey()).substring(level.isEmpty() ? 0 : level.length() + 1), (String)e.getValue())).filter(e -> !((String)e.getKey()).contains(".")).forEach(e -> res.put((String)e.getKey(), (String)e.getValue()));
        if (this.backup != null) {
            this.backup.getValues(path).forEach(res::putIfAbsent);
        }
        return res;
    }

    public HashMap<String, String> getValuesDeep(Object ... path) {
        String level = this.path(path);
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        this.values.entrySet().stream().filter(e -> level.isEmpty() || ((String)e.getKey()).startsWith(level + ".")).map(e -> Map.entry(((String)e.getKey()).substring(level.isEmpty() ? 0 : level.length() + 1), (String)e.getValue())).forEach(e -> res.put((String)e.getKey(), (String)e.getValue()));
        if (this.backup != null) {
            this.backup.getValuesDeep(path).forEach(res::putIfAbsent);
        }
        return res;
    }

    public Storage set(Object ... pathAndValue) {
        return this.set(true, pathAndValue);
    }

    public synchronized Storage set(boolean overwrite, Object ... pathAndValue) {
        List<Object> list;
        if (pathAndValue.length < 2) {
            throw new IllegalArgumentException("path-value pair was not supplied");
        }
        Object value = pathAndValue[pathAndValue.length - 1];
        Object[] path = Arrays.copyOf(pathAndValue, pathAndValue.length - 1);
        String level = this.path(path);
        if (!overwrite && this.exists(level)) {
            return this;
        }
        if (value.getClass().isArray() && !((Class)value.getClass().componentType()).isPrimitive()) {
            value = Arrays.asList((Object[])value);
        }
        if ((list = value) instanceof Collection) {
            Collection c = list;
            value = c.stream().map(Objects::toString).collect(Collectors.joining("\n"));
        }
        this.values.put(level, Objects.toString(value));
        return this;
    }

    public synchronized Storage remove(Object ... path) {
        this.values.remove(this.path(path));
        return this;
    }

    public synchronized Storage removeLevel(Object ... path) {
        String level = this.path(path);
        if (level.isEmpty()) {
            this.values.clear();
        } else {
            this.values.keySet().removeIf(key -> key.startsWith(level + "."));
        }
        return this;
    }

    private static Map<Fold, Object> fold(Map<String, String> values) {
        LinkedHashMap<Fold, Object> res = new LinkedHashMap<Fold, Object>();
        values.forEach((k, v) -> {
            Map map = res;
            String[] path = k.split("\\.");
            for (int i = 0; i < path.length; ++i) {
                Fold fold = new Fold(path[i], i + 1 < path.length);
                if (fold.level) {
                    map = (Map)map.computeIfAbsent(fold, f -> new LinkedHashMap());
                    continue;
                }
                map.put(fold, v);
            }
        });
        return res;
    }

    private static void unfold(Map<String, String> res, Map<Fold, Object> fold, String prefix) {
        fold.forEach((k, v) -> {
            if (k.level) {
                Storage.unfold(res, (Map)v, prefix + k.key + ".");
            } else {
                res.put(prefix + k.key, (String)v);
            }
        });
    }

    public synchronized Storage reorder() {
        Map<Fold, Object> fold = Storage.fold(this.values);
        this.values.clear();
        Storage.unfold(this.values, fold, "");
        return this;
    }

    private static <T> T iae(String s, Function<String, T> f, T def) {
        if (s != null) {
            try {
                return f.apply(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return def;
    }

    public boolean getBoolean(Object ... path) {
        return Storage.iae(this.getString(path), "true"::equalsIgnoreCase, false);
    }

    public List<Boolean> getBooleanList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, "true"::equalsIgnoreCase, false)).collect(Collectors.toList());
    }

    public byte getByte(Object ... path) {
        return Storage.iae(this.getString(path), Byte::decode, (byte)0);
    }

    public List<Byte> getByteList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, Byte::decode, (byte)0)).collect(Collectors.toList());
    }

    public short getShort(Object ... path) {
        return Storage.iae(this.getString(path), Short::decode, (short)0);
    }

    public List<Short> getShortList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, Short::decode, (short)0)).collect(Collectors.toList());
    }

    public int getInt(Object ... path) {
        return Storage.iae(this.getString(path), Integer::decode, 0);
    }

    public List<Integer> getIntList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, Integer::decode, 0)).collect(Collectors.toList());
    }

    public float getFloat(Object ... path) {
        return Storage.iae(this.getString(path), Float::parseFloat, Float.valueOf(0.0f)).floatValue();
    }

    public List<Float> getFloatList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, Float::parseFloat, Float.valueOf(0.0f))).collect(Collectors.toList());
    }

    public long getLong(Object ... path) {
        return Storage.iae(this.getString(path), Long::parseLong, 0L);
    }

    public List<Long> getLongList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, Long::parseLong, 0L)).collect(Collectors.toList());
    }

    public double getDouble(Object ... path) {
        return Storage.iae(this.getString(path), Double::parseDouble, 0.0);
    }

    public List<Double> getDoubleList(Object ... path) {
        return this.getStringList(path).stream().map(s -> Storage.iae(s, Double::parseDouble, 0.0)).collect(Collectors.toList());
    }

    public Storage backup() {
        return this.backup;
    }

    public Storage backup(Storage backup) {
        this.backup = backup;
        return this;
    }

    public Storage backupTail() {
        Storage backup = this.backup;
        if (backup == null) {
            return this;
        }
        while (backup.backup != null) {
            backup = backup.backup;
        }
        return backup;
    }

    public Storage backupInsert(Storage chain) {
        if (chain == null) {
            return this;
        }
        chain.backupTail().backup = this.backup;
        this.backup = chain;
        return this;
    }

    public Storage backupAppend(Storage chain) {
        if (chain == null) {
            return this;
        }
        this.backupTail().backup = chain;
        return this;
    }

    public Storage backupLossy(Storage backup) {
        if (backup == null) {
            return this;
        }
        Storage previous = this.backup;
        this.backup = backup;
        if (previous != null) {
            backup.backup = previous;
        }
        return this;
    }

    private record Fold(String key, boolean level) {
    }
}

