/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.d3;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.diversionmc.d3.Storage;

public record StoragePath(Storage storage, Object[] path) {
    public static Object[] combine(Object[] a, Object[] b) {
        Object[] res = new Object[a.length + b.length];
        System.arraycopy(a, 0, res, 0, a.length);
        System.arraycopy(b, 0, res, a.length, b.length);
        return res;
    }

    public List<StoragePath> levels() {
        return this.storage.levels(this.path);
    }

    public List<String> getLevels() {
        return this.storage.getLevels(this.path);
    }

    public void forEachLevel(Consumer<StoragePath> level) {
        this.levels().forEach(level);
    }

    public Map<String, String> getValues() {
        return this.storage.getValues(this.path);
    }

    public void forEachValue(BiConsumer<String, String> values) {
        this.getValues().forEach(values);
    }

    public Map<String, String> getValuesDeep() {
        return this.storage.getValuesDeep(this.path);
    }

    public void forEachValueDeep(BiConsumer<String, String> values) {
        this.getValuesDeep().forEach(values);
    }

    @Deprecated(since="1.7", forRemoval=true)
    public StoragePath append(Object ... path) {
        return this.get(path);
    }

    public StoragePath get(Object ... path) {
        return new StoragePath(this.storage, StoragePath.combine(this.path, path));
    }

    public StoragePath set(Object ... pathAndValue) {
        return this.set(true, pathAndValue);
    }

    public StoragePath set(boolean overwrite, Object ... pathAndValue) {
        this.storage.set(overwrite, StoragePath.combine(this.path, pathAndValue));
        return this;
    }

    public StoragePath remove(Object ... path) {
        this.storage.remove(StoragePath.combine(this.path, path));
        return this;
    }

    public StoragePath removeLevel(Object ... path) {
        this.storage.removeLevel(StoragePath.combine(this.path, path));
        return this;
    }

    public boolean exists() {
        return this.storage.exists(this.path);
    }

    public String getString() {
        return this.storage.getString(this.path);
    }

    public List<String> getStringList() {
        return this.storage.getStringList(this.path);
    }

    public boolean getBoolean() {
        return this.storage.getBoolean(this.path);
    }

    public List<Boolean> getBooleanList() {
        return this.storage.getBooleanList(this.path);
    }

    public byte getByte() {
        return this.storage.getByte(this.path);
    }

    public List<Byte> getByteList() {
        return this.storage.getByteList(this.path);
    }

    public short getShort() {
        return this.storage.getShort(this.path);
    }

    public List<Short> getShortList() {
        return this.storage.getShortList(this.path);
    }

    public int getInt() {
        return this.storage.getInt(this.path);
    }

    public List<Integer> getIntList() {
        return this.storage.getIntList(this.path);
    }

    public float getFloat() {
        return this.storage.getFloat(this.path);
    }

    public List<Float> getFloatList() {
        return this.storage.getFloatList(this.path);
    }

    public long getLong() {
        return this.storage.getLong(this.path);
    }

    public List<Long> getLongList() {
        return this.storage.getLongList(this.path);
    }

    public double getDouble() {
        return this.storage.getDouble(this.path);
    }

    public List<Double> getDoubleList() {
        return this.storage.getDoubleList(this.path);
    }

    public boolean exists(Object ... path) {
        return this.append(path).exists();
    }

    public String getString(Object ... path) {
        return this.append(path).getString();
    }

    public List<String> getStringList(Object ... path) {
        return this.append(path).getStringList();
    }

    public boolean getBoolean(Object ... path) {
        return this.append(path).getBoolean();
    }

    public List<Boolean> getBooleanList(Object ... path) {
        return this.append(path).getBooleanList();
    }

    public byte getByte(Object ... path) {
        return this.append(path).getByte();
    }

    public List<Byte> getByteList(Object ... path) {
        return this.append(path).getByteList();
    }

    public short getShort(Object ... path) {
        return this.append(path).getShort();
    }

    public List<Short> getShortList(Object ... path) {
        return this.append(path).getShortList();
    }

    public int getInt(Object ... path) {
        return this.append(path).getInt();
    }

    public List<Integer> getIntList(Object ... path) {
        return this.append(path).getIntList();
    }

    public float getFloat(Object ... path) {
        return this.append(path).getFloat();
    }

    public List<Float> getFloatList(Object ... path) {
        return this.append(path).getFloatList();
    }

    public long getLong(Object ... path) {
        return this.append(path).getLong();
    }

    public List<Long> getLongList(Object ... path) {
        return this.append(path).getLongList();
    }

    public double getDouble(Object ... path) {
        return this.append(path).getDouble();
    }

    public List<Double> getDoubleList(Object ... path) {
        return this.append(path).getDoubleList();
    }
}

