/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.d3.structure;

import net.diversionmc.d3.structure.LevelEnd;
import net.diversionmc.d3.structure.LevelStart;
import net.diversionmc.d3.structure.ListStart;
import net.diversionmc.parser.expression.CommentPiece;
import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.PieceResult;
import net.diversionmc.parser.util.FilePointer;

public class Path
extends ExpressionPiece {
    StringBuilder path = new StringBuilder();
    boolean space = false;
    boolean comment = false;
    char last;

    public Path(FilePointer ptr) {
        super(ptr);
    }

    public PieceResult read(char c, FilePointer ptr) {
        if (c == '\n') {
            return PieceResult.REPLACE_LEAVE;
        }
        if (this.last == '/' && (c == '/' || c == '*')) {
            this.path.deleteCharAt(this.path.length() - 1);
            this.last = c;
            this.comment = true;
            return PieceResult.REPLACE_TAKE;
        }
        if (Character.isWhitespace(c)) {
            this.space = true;
            return PieceResult.CONTINUE;
        }
        if (this.space) {
            return PieceResult.LEAVE;
        }
        this.last = c;
        this.path.append(this.last);
        return PieceResult.CONTINUE;
    }

    public ExpressionPiece replace(FilePointer ptr) {
        if (this.comment) {
            this.comment = false;
            return new CommentPiece(ptr, this.last == '/', (ExpressionPiece)this);
        }
        String path = this.path();
        if (path.isEmpty()) {
            return null;
        }
        if (path.equals("<")) {
            return new LevelEnd(ptr);
        }
        if (this.last == '[') {
            return new ListStart(ptr, path.substring(0, path.length() - 1));
        }
        return new LevelStart(ptr, path);
    }

    public String path() {
        return this.path.toString();
    }
}

