/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.diversionmc.error.ResultException;
import net.diversionmc.error.Success;

public final class Result<S, E> {
    private final S ok;
    private final E error;

    public static <S, E> Result<S, E> ok(S s) {
        if (s == null) {
            throw new IllegalArgumentException("Supplied null to result");
        }
        return new Result<S, Object>(s, null);
    }

    public static <S, E> Result<S, E> error(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Supplied null to result");
        }
        return new Result<Object, E>(null, e);
    }

    private Result(S ok, E error) {
        this.ok = ok;
        this.error = error;
    }

    public Optional<S> ok() {
        return Optional.ofNullable(this.ok);
    }

    public Optional<E> error() {
        return Optional.ofNullable(this.error);
    }

    public boolean isOk() {
        return this.ok != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public Success<E> success() {
        return this.isOk() ? Success.ok() : Success.error(this.error);
    }

    public String toString() {
        return "" + (this.isOk() ? this.ok : this.error);
    }

    public <S2, E2> Result<S2, E2> map(Function<Result<S, E>, Result<S2, E2>> mapper) {
        return mapper.apply(this);
    }

    public <S2> Result<S2, E> mapOk(Function<S, S2> mapper) {
        return this.isOk() ? Result.ok(mapper.apply(this.ok)) : Result.error(this.error);
    }

    public <E2> Result<S, E2> mapError(Function<E, E2> mapper) {
        return this.isOk() ? Result.ok(this.ok) : Result.error(mapper.apply(this.error));
    }

    public <S2> Result<S2, E> flatMapResult(Function<S, Result<S2, E>> mapper) {
        return this.isOk() ? mapper.apply(this.ok) : Result.error(this.error);
    }

    public Success<E> flatMapSuccess(Function<S, Success<E>> mapper) {
        return this.isOk() ? mapper.apply(this.ok) : Success.error(this.error);
    }

    public Result<S, E> peek(Consumer<Result<S, E>> peeker) {
        peeker.accept(this);
        return this;
    }

    public Result<S, E> peekOk(Consumer<S> peeker) {
        if (this.isOk()) {
            peeker.accept(this.ok);
        }
        return this;
    }

    public Result<S, E> peekError(Consumer<E> peeker) {
        if (this.isError()) {
            peeker.accept(this.error);
        }
        return this;
    }

    public static <S, E extends Exception> Result<S, E> tryGet(Class<E> ce, Supplier<S> s) {
        try {
            return Result.ok(s.get());
        }
        catch (ResultException e) {
            Exception ex = e.exception();
            if (ce.isInstance(ex)) {
                return Result.error(ex);
            }
            throw e;
        }
    }

    public static <S, E> Collector<Result<S, E>, Results<S, E>, Results<S, E>> toResults() {
        return Collector.of(Results::new, (results, result) -> result.peekOk(results.oks::add).peekError(results.errors::add), Results::combine, results -> results, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <S, E> Collector<Result<S, E>, Results<S, E>, Result<List<S>, E>> toResultList() {
        return Collector.of(Results::new, (results, result) -> result.peekOk(results.oks::add).peekError(results.errors::add), Results::combine, results -> results.errors.stream().findFirst().map(Result::error).orElseGet(() -> Result.ok(results.oks)), new Collector.Characteristics[0]);
    }

    public static class Results<S, E> {
        private final List<S> oks = new ArrayList<S>();
        private final List<E> errors = new ArrayList();

        public Results<S, E> combine(Results<S, E> other) {
            Results<S, E> res = new Results<S, E>();
            res.oks.addAll(this.oks);
            res.oks.addAll(other.oks);
            res.errors.addAll(this.errors);
            res.errors.addAll(other.errors);
            return res;
        }

        public List<S> oks() {
            return Collections.unmodifiableList(this.oks);
        }

        public List<E> errors() {
            return Collections.unmodifiableList(this.errors);
        }

        public String toString() {
            return "{%s, %s}".formatted(this.oks, this.errors);
        }
    }
}

