/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.error;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.diversionmc.error.Result;
import net.diversionmc.error.ResultException;

public final class Success<E> {
    private final E error;

    public static <E> Success<E> ok() {
        return new Success<Object>(null);
    }

    public static <E> Success<E> error(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Supplied null to success");
        }
        return new Success<E>(e);
    }

    private Success(E error) {
        this.error = error;
    }

    public Optional<E> error() {
        return Optional.ofNullable(this.error);
    }

    public boolean isOk() {
        return this.error == null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public String toString() {
        return this.isOk() ? "" : "" + this.error;
    }

    public <E2> Success<E2> map(Function<Success<E>, Success<E2>> mapper) {
        return mapper.apply(this);
    }

    public <S2> Result<S2, E> mapOk(Supplier<S2> mapper) {
        return this.isOk() ? Result.ok(mapper.get()) : Result.error(this.error);
    }

    public <E2> Success<E2> mapError(Function<E, E2> mapper) {
        return this.isOk() ? Success.ok() : Success.error(mapper.apply(this.error));
    }

    public <S2> Result<S2, E> flatMapResult(Supplier<Result<S2, E>> mapper) {
        return this.isOk() ? mapper.get() : Result.error(this.error);
    }

    public Success<E> flatMapSuccess(Supplier<Success<E>> mapper) {
        return this.isOk() ? mapper.get() : Success.error(this.error);
    }

    public Success<E> peek(Consumer<Success<E>> peeker) {
        peeker.accept(this);
        return this;
    }

    public Success<E> peekOk(Runnable peeker) {
        if (this.isOk()) {
            peeker.run();
        }
        return this;
    }

    public Success<E> peekError(Consumer<E> peeker) {
        if (this.isError()) {
            peeker.accept(this.error);
        }
        return this;
    }

    public static <E extends Exception> Success<E> tryRun(Class<E> ce, Runnable r) {
        try {
            r.run();
            return Success.ok();
        }
        catch (ResultException e) {
            if (ce.isInstance(e.exception())) {
                return Success.error(e);
            }
            throw e;
        }
    }

    public static <E> Collector<Success<E>, List<E>, Success<E>> toSuccess() {
        return Collector.of(ArrayList::new, (errors, success) -> success.peekError(errors::add), (errors1, errors2) -> {
            ArrayList l = new ArrayList();
            l.addAll(errors1);
            l.addAll(errors2);
            return l;
        }, errors -> errors.stream().findFirst().map(Success::error).orElseGet(Success::ok), new Collector.Characteristics[0]);
    }
}

