/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.tool.ueditor;

import javax.servlet.http.HttpServletRequest;
import net.dreamlu.tool.ueditor.ActionConfig;
import net.dreamlu.tool.ueditor.UeditorConfig;
import net.dreamlu.tool.ueditor.UeditorManager;
import net.dreamlu.tool.ueditor.define.ActionMap;
import net.dreamlu.tool.ueditor.define.BaseState;
import net.dreamlu.tool.ueditor.define.State;
import net.dreamlu.tool.ueditor.hunter.ImageHunter;
import net.dreamlu.tool.ueditor.manager.IUeditorFileManager;
import net.dreamlu.tool.ueditor.uploader.Uploader;
import net.dreamlu.tool.util.JsonUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class UeditorService {
    private UeditorManager ueditorManager;

    public UeditorService() {
    }

    public UeditorService(UeditorManager ueditorManager) {
        this.ueditorManager = ueditorManager;
    }

    public ResponseEntity<String> upload(HttpServletRequest request) {
        String callbackName = request.getParameter("callback");
        String json = callbackName == null ? this.invoke(request) : (!this.validCallbackName(callbackName) ? new BaseState(false, 401).toJSONString() : callbackName + "(" + this.invoke(request) + ");");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)json, (MultiValueMap)headers, HttpStatus.OK);
    }

    private String invoke(HttpServletRequest request) {
        String actionType = request.getParameter("action");
        String ctxPath = request.getContextPath();
        if (actionType == null || !ActionMap.containsKey(actionType)) {
            return new BaseState(false, 101).toJSONString();
        }
        if (this.ueditorManager == null || !this.ueditorManager.valid()) {
            return new BaseState(false, 102).toJSONString();
        }
        IUeditorFileManager fileManager = this.ueditorManager.getFileManager();
        State state = null;
        int actionCode = ActionMap.getType(actionType);
        ActionConfig conf = null;
        switch (actionCode) {
            case 0: {
                UeditorConfig allConfig = this.ueditorManager.getConfig();
                String imageUrlPrefix = allConfig.getImageUrlPrefix();
                String scrawlUrlPrefix = allConfig.getScrawlUrlPrefix();
                String snapscreenUrlPrefix = allConfig.getSnapscreenUrlPrefix();
                String catcherUrlPrefix = allConfig.getCatcherUrlPrefix();
                String videoUrlPrefix = allConfig.getVideoUrlPrefix();
                String fileUrlPrefix = allConfig.getFileUrlPrefix();
                String imageManagerUrlPrefix = allConfig.getImageManagerUrlPrefix();
                String fileManagerUrlPrefix = allConfig.getFileManagerUrlPrefix();
                if (StringUtils.hasText((String)imageUrlPrefix)) {
                    allConfig.setImageUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)scrawlUrlPrefix)) {
                    allConfig.setScrawlUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)snapscreenUrlPrefix)) {
                    allConfig.setSnapscreenUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)catcherUrlPrefix)) {
                    allConfig.setCatcherUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)videoUrlPrefix)) {
                    allConfig.setVideoUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)fileUrlPrefix)) {
                    allConfig.setFileUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)imageManagerUrlPrefix)) {
                    allConfig.setImageManagerUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)fileManagerUrlPrefix)) {
                    allConfig.setFileManagerUrlPrefix(ctxPath);
                }
                return JsonUtils.toJson((Object)allConfig);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                conf = this.ueditorManager.getConfig(actionCode);
                state = new Uploader(request, conf).doExec(fileManager);
                break;
            }
            case 5: {
                conf = this.ueditorManager.getConfig(actionCode);
                String[] list = request.getParameterValues(conf.getFieldName());
                state = new ImageHunter(fileManager, conf).capture(list);
                break;
            }
            case 6: 
            case 7: {
                conf = this.ueditorManager.getConfig(actionCode);
                int start = this.getStartIndex(request);
                state = fileManager.list(conf, start);
                break;
            }
        }
        return state.toJSONString();
    }

    private int getStartIndex(HttpServletRequest request) {
        String start = request.getParameter("start");
        try {
            return Integer.parseInt(start);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private boolean validCallbackName(String name) {
        return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
    }

    public void setUeditorManager(UeditorManager ueditorManager) {
        this.ueditorManager = ueditorManager;
    }

    public UeditorManager getUeditorManager() {
        return this.ueditorManager;
    }
}

