/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.tool.ueditor.define;

import java.util.HashMap;
import java.util.Map;
import net.dreamlu.tool.ueditor.Encoder;
import net.dreamlu.tool.ueditor.define.AppInfo;
import net.dreamlu.tool.ueditor.define.State;
import net.dreamlu.tool.util.JsonUtils;

public class BaseState
implements State {
    private boolean state = false;
    private String info = null;
    private Map<String, Object> infoMap = new HashMap<String, Object>();

    public BaseState() {
        this.state = true;
    }

    public BaseState(boolean state) {
        this.setState(state);
    }

    public BaseState(boolean state, String info) {
        this.setState(state);
        this.info = info;
    }

    public BaseState(boolean state, int infoCode) {
        this.setState(state);
        this.info = AppInfo.getStateInfo(infoCode);
    }

    @Override
    public boolean isSuccess() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setInfo(int infoCode) {
        this.info = AppInfo.getStateInfo(infoCode);
    }

    @Override
    public String toJSONString() {
        this.toJSONObject();
        return Encoder.toUnicode(JsonUtils.toJson(this.infoMap));
    }

    @Override
    public void putInfo(String name, String val) {
        this.infoMap.put(name, val);
    }

    @Override
    public void putInfo(String name, long val) {
        this.putInfo(name, val + "");
    }

    @Override
    public Map<String, Object> toJSONObject() {
        String stateVal = this.isSuccess() ? AppInfo.getStateInfo(0) : this.info;
        this.infoMap.put("state", stateVal);
        return this.infoMap;
    }
}

