/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.tool.ueditor.uploader;

import net.dreamlu.tool.ueditor.ActionConfig;
import net.dreamlu.tool.ueditor.PathFormat;
import net.dreamlu.tool.ueditor.define.BaseState;
import net.dreamlu.tool.ueditor.define.FileType;
import net.dreamlu.tool.ueditor.define.State;
import net.dreamlu.tool.ueditor.manager.IUeditorFileManager;
import org.springframework.util.Base64Utils;

public final class Base64Uploader {
    public static State save(IUeditorFileManager fileManager, String content, ActionConfig conf) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = conf.getMaxSize())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        String savePath = PathFormat.parse(conf.getSavePath(), conf.getFilename());
        State storageState = fileManager.saveFile(data, savePath = savePath + suffix);
        if (storageState.isSuccess()) {
            storageState.putInfo("url", PathFormat.format(savePath));
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", "");
        }
        return storageState;
    }

    private static byte[] decode(String content) {
        return Base64Utils.decodeFromString((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

