/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.tool.ueditor.uploader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.dreamlu.tool.ueditor.ActionConfig;
import net.dreamlu.tool.ueditor.PathFormat;
import net.dreamlu.tool.ueditor.define.BaseState;
import net.dreamlu.tool.ueditor.define.FileType;
import net.dreamlu.tool.ueditor.define.State;
import net.dreamlu.tool.ueditor.manager.IUeditorFileManager;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BinaryUploader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final State save(IUeditorFileManager fileManager, HttpServletRequest request, ActionConfig conf) {
        if (!(request instanceof MultipartHttpServletRequest)) {
            return new BaseState(false, 5);
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        String fieldName = conf.getFieldName();
        MultipartFile file = multipartRequest.getFile(fieldName);
        String savePath = conf.getSavePath();
        String originFileName = file.getOriginalFilename();
        String suffix = FileType.getSuffixByFilename(originFileName);
        originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
        savePath = savePath + suffix;
        long maxSize = conf.getMaxSize();
        if (!BinaryUploader.validType(suffix, conf.getAllowFiles())) {
            return new BaseState(false, 8);
        }
        savePath = PathFormat.parse(savePath, originFileName);
        try (InputStream is = file.getInputStream();){
            State storageState = fileManager.saveFile(is, savePath, maxSize);
            if (storageState.isSuccess()) {
                storageState.putInfo("url", PathFormat.format(savePath));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            State state = storageState;
            return state;
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, List<String> allowTypes) {
        return allowTypes.contains(type);
    }
}

