/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.http.HttpResponse;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;

public class BytesResponse
implements ResponseSpec,
Closeable {
    private final Request request;
    private final Response response;
    private final ResponseBody responseBody;
    private final byte[] body;

    public BytesResponse(Response response) {
        this.request = response.request();
        this.response = response;
        this.responseBody = HttpResponse.ifNullBodyToEmpty(response.body());
        this.body = BytesResponse.ifNullBodyToEmpty(response.body());
    }

    @Override
    public int code() {
        return this.response.code();
    }

    @Override
    public boolean isOk() {
        return this.response.isSuccessful();
    }

    @Override
    public String message() {
        return this.response.message();
    }

    @Override
    public boolean isRedirect() {
        return this.response.isRedirect();
    }

    @Override
    public Headers headers() {
        return this.response.headers();
    }

    @Override
    public List<Cookie> cookies() {
        return Cookie.parseAll((HttpUrl)this.request.url(), (Headers)this.headers());
    }

    @Override
    public String asString() {
        return this.asString(StandardCharsets.UTF_8);
    }

    @Override
    public String asString(Charset charset) {
        return new String(this.body, charset);
    }

    @Override
    public byte[] asBytes() {
        return this.body;
    }

    @Override
    public InputStream asStream() {
        return new ByteArrayInputStream(this.body);
    }

    @Override
    public JsonNode asJsonNode() {
        return JsonUtil.readTree((byte[])this.body);
    }

    @Override
    @Nullable
    public <T> T asValue(Class<T> valueType) {
        return (T)JsonUtil.readValue((byte[])this.body, valueType);
    }

    @Override
    @Nullable
    public <T> T asValue(TypeReference<T> typeReference) {
        return (T)JsonUtil.readValue((byte[])this.body, typeReference);
    }

    @Override
    public <T> List<T> asList(Class<T> valueType) {
        return JsonUtil.readList((byte[])this.body, valueType);
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<?> keyClass, Class<?> valueType) {
        return JsonUtil.readMap((byte[])this.body, keyClass, valueType);
    }

    @Override
    public <V> Map<String, V> asMap(Class<?> valueType) {
        return JsonUtil.readMap((byte[])this.body, String.class, valueType);
    }

    @Override
    public File toFile(File file) {
        this.toFile(file.toPath());
        return file;
    }

    @Override
    public Path toFile(Path path) {
        try {
            return Files.write(path, this.body, new OpenOption[0]);
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    @Override
    public long contentLength() {
        return this.responseBody.contentLength();
    }

    @Override
    public Request rawRequest() {
        return this.request;
    }

    @Override
    public Response rawResponse() {
        return this.response;
    }

    @Override
    @Nullable
    public ResponseBody rawBody() {
        return this.responseBody;
    }

    public String toString() {
        return this.response.toString();
    }

    static byte[] ifNullBodyToEmpty(@Nullable ResponseBody body) {
        if (body == null) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        try {
            return body.bytes();
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        Util.closeQuietly((Closeable)this.response.body());
    }
}

