/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dreamlu.mica.http.BytesResponse;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

@ParametersAreNonnullByDefault
public class CompletableCallback
implements Callback {
    private final CompletableFuture<ResponseSpec> future;

    public CompletableCallback(CompletableFuture<ResponseSpec> future) {
        this.future = future;
    }

    public void onFailure(Call call, IOException e) {
        this.future.completeExceptionally(e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        try (BytesResponse bytesResponse = new BytesResponse(response);){
            this.future.complete(bytesResponse);
        }
    }
}

