/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(value="mica.logging")
public class MicaLoggingProperties {
    public static final String PREFIX = "mica.logging";
    private final Console console = new Console();
    private final Files files = new Files();
    private final Logstash logstash = new Logstash();

    public Console getConsole() {
        return this.console;
    }

    public Files getFiles() {
        return this.files;
    }

    public Logstash getLogstash() {
        return this.logstash;
    }

    public static class Logstash {
        public static final String PREFIX = "mica.logging.logstash";
        private boolean enabled = false;
        private String host = "localhost";
        private int port = 5000;
        private int queueSize = 512;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }

    public static class Files {
        public static final String PREFIX = "mica.logging.files";
        private boolean enabled = true;
        private boolean useJsonFormat = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isUseJsonFormat() {
            return this.useJsonFormat;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setUseJsonFormat(boolean useJsonFormat) {
            this.useJsonFormat = useJsonFormat;
        }
    }

    public static class Console {
        private boolean closeAfterStart = false;

        public boolean isCloseAfterStart() {
            return this.closeAfterStart;
        }

        public void setCloseAfterStart(boolean closeAfterStart) {
            this.closeAfterStart = closeAfterStart;
        }
    }
}

