/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.dreamlu.iot.mqtt.codec.MqttQoS;

public class MqttSubAckPayload {
    private final List<Integer> reasonCodes;

    public MqttSubAckPayload(int ... reasonCodes) {
        Objects.requireNonNull(reasonCodes, "reasonCodes is null.");
        ArrayList<Integer> list = new ArrayList<Integer>(reasonCodes.length);
        for (int v : reasonCodes) {
            list.add(v);
        }
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public MqttSubAckPayload(Iterable<Integer> reasonCodes) {
        Objects.requireNonNull(reasonCodes, "reasonCodes is null.");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer v : reasonCodes) {
            if (v == null) break;
            list.add(v);
        }
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public List<Integer> grantedQoSLevels() {
        ArrayList<Integer> qosLevels = new ArrayList<Integer>(this.reasonCodes.size());
        for (int code : this.reasonCodes) {
            if (code > MqttQoS.EXACTLY_ONCE.value()) {
                qosLevels.add(MqttQoS.FAILURE.value());
                continue;
            }
            qosLevels.add(code);
        }
        return qosLevels;
    }

    public List<Integer> reasonCodes() {
        return this.reasonCodes;
    }

    public String toString() {
        return "MqttSubAckPayload[reasonCodes=" + this.reasonCodes + ']';
    }
}

