/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.prometheus.api.config;

import net.dreamlu.mica.prometheus.api.core.PrometheusApi;
import net.dreamlu.mica.prometheus.api.core.ReactivePrometheusApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
public class PrometheusConfiguration {

    @AutoConfiguration
    @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnReactiveDiscoveryEnabled
    public static class ReactivePrometheusApiConfiguration {
        @Bean
        public ReactivePrometheusApi reactivePrometheusApi(Environment environment, ReactiveDiscoveryClient discoveryClient, ApplicationEventPublisher eventPublisher) {
            String[] activeProfiles = environment.getActiveProfiles();
            String activeProfile = activeProfiles.length > 0 ? activeProfiles[0] : null;
            return new ReactivePrometheusApi(activeProfile, discoveryClient, eventPublisher);
        }
    }

    @AutoConfiguration
    @ConditionalOnBean(value={DiscoveryClient.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnProperty(value={"spring.cloud.discovery.blocking.enabled"})
    public static class PrometheusApiConfiguration {
        @Bean
        public PrometheusApi prometheusApi(Environment environment, DiscoveryClient discoveryClient, ApplicationEventPublisher eventPublisher) {
            String[] activeProfiles = environment.getActiveProfiles();
            String activeProfile = activeProfiles.length > 0 ? activeProfiles[0] : null;
            return new PrometheusApi(activeProfile, discoveryClient, eventPublisher);
        }
    }
}

