/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.prometheus.api.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.dreamlu.mica.prometheus.api.pojo.AlertMessage;
import net.dreamlu.mica.prometheus.api.pojo.TargetGroup;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"actuator/prometheus"})
public class PrometheusApi {
    private final String activeProfile;
    private final DiscoveryClient discoveryClient;
    private final ApplicationEventPublisher eventPublisher;

    @GetMapping(value={"sd"})
    public List<TargetGroup> getList() {
        List serviceIdList = this.discoveryClient.getServices();
        if (serviceIdList == null || serviceIdList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TargetGroup> targetGroupList = new ArrayList<TargetGroup>();
        for (String serviceId : serviceIdList) {
            List instanceList = this.discoveryClient.getInstances(serviceId);
            ArrayList<String> targets = new ArrayList<String>();
            for (ServiceInstance instance : instanceList) {
                targets.add(String.format("%s:%d", instance.getHost(), instance.getPort()));
            }
            HashMap<String, String> labels = new HashMap<String, String>(4);
            if (StringUtils.hasText((String)this.activeProfile)) {
                labels.put("profile", this.activeProfile);
            }
            labels.put("__meta_prometheus_job", serviceId);
            targetGroupList.add(new TargetGroup(targets, labels));
        }
        return targetGroupList;
    }

    @PostMapping(value={"alerts"})
    public ResponseEntity<Object> postAlerts(@RequestBody AlertMessage message) {
        this.eventPublisher.publishEvent((Object)message);
        return ResponseEntity.ok().build();
    }

    public PrometheusApi(String activeProfile, DiscoveryClient discoveryClient, ApplicationEventPublisher eventPublisher) {
        this.activeProfile = activeProfile;
        this.discoveryClient = discoveryClient;
        this.eventPublisher = eventPublisher;
    }
}

