/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.prometheus.api.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dreamlu.mica.prometheus.api.pojo.AlertMessage;
import net.dreamlu.mica.prometheus.api.pojo.TargetGroup;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"actuator/prometheus"})
public class ReactivePrometheusApi {
    private final String activeProfile;
    private final ReactiveDiscoveryClient discoveryClient;
    private final ApplicationEventPublisher eventPublisher;

    @GetMapping(value={"sd"})
    public Flux<TargetGroup> getList() {
        return this.discoveryClient.getServices().flatMap(arg_0 -> ((ReactiveDiscoveryClient)this.discoveryClient).getInstances(arg_0)).groupBy(ServiceInstance::getServiceId, instance -> String.format("%s:%d", instance.getHost(), instance.getPort())).flatMap(instanceGrouped -> {
            HashMap<String, String> labels = new HashMap<String, String>(4);
            if (StringUtils.hasText((String)this.activeProfile)) {
                labels.put("profile", this.activeProfile);
            }
            String serviceId = (String)instanceGrouped.key();
            labels.put("__meta_prometheus_job", serviceId);
            return instanceGrouped.collect(Collectors.toList()).map(targets -> new TargetGroup((List<String>)targets, (Map<String, String>)labels));
        });
    }

    @PostMapping(value={"alerts"})
    public ResponseEntity<Object> postAlerts(@RequestBody AlertMessage message) {
        this.eventPublisher.publishEvent((Object)message);
        return ResponseEntity.ok().build();
    }

    public ReactivePrometheusApi(String activeProfile, ReactiveDiscoveryClient discoveryClient, ApplicationEventPublisher eventPublisher) {
        this.activeProfile = activeProfile;
        this.discoveryClient = discoveryClient;
        this.eventPublisher = eventPublisher;
    }
}

