/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.actor.pool;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Status;
import java.util.concurrent.Callable;
import net.e6tech.elements.common.actor.pool.Events;
import scala.concurrent.ExecutionContext;

public class Worker
extends AbstractActor {
    private ActorRef pool;
    private ExecutionContext ec;

    public Worker(ActorRef pool) {
        this.pool = pool;
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Runnable.class, event -> {
            try {
                event.run();
                this.getSender().tell((Object)new Events.Response(), this.getSelf());
            }
            catch (Throwable th) {
                this.getSender().tell((Object)new Status.Failure(th), this.getSelf());
            }
            finally {
                this.pool.tell((Object)new Events.IdleWorker(this.getSelf()), this.getSelf());
            }
        }).match(Callable.class, event -> {
            try {
                Object ret = event.call();
                this.getSender().tell((Object)new Events.Response(ret), this.getSelf());
            }
            catch (Throwable th) {
                this.getSender().tell((Object)new Status.Failure(th), this.getSelf());
            }
            finally {
                this.pool.tell((Object)new Events.IdleWorker(this.getSelf()), this.getSelf());
            }
        }).build();
    }
}

