/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.reflection.Reflection;

public class Interceptor {
    private Map<Class, WeakReference<Class>> proxyClasses = Collections.synchronizedMap(new WeakHashMap(199));
    private static Interceptor instance = new Interceptor();

    public static Interceptor getInstance() {
        return instance;
    }

    protected Class createClass(Class cls) {
        Class proxyClass;
        WeakReference<Class> ref = this.proxyClasses.get(cls);
        Class clazz = proxyClass = ref == null ? null : (Class)ref.get();
        if (proxyClass == null) {
            proxyClass = new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)))).intercept((Implementation)MethodDelegation.toField((String)"handler")).defineField("handler", Handler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{HandlerAccessor.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).make().load(cls.getClassLoader()).getLoaded();
            this.proxyClasses.put(cls, new WeakReference<Class>(proxyClass));
        }
        return proxyClass;
    }

    public static <T> Class<T> newPrototypeClass(Class<T> cls, T prototype) {
        Class proxyClass = new ByteBuddy().subclass(cls).constructor((ElementMatcher)ElementMatchers.any()).intercept(SuperMethodCall.INSTANCE.andThen((Implementation)MethodDelegation.to(new Constructor<T>(prototype)))).make().load(cls.getClassLoader()).getLoaded();
        return proxyClass;
    }

    public static <T> Class<T> newSingletonClass(Class<T> cls, T singleton) {
        return Interceptor.newSingletonClass(cls, singleton, null);
    }

    public static <T> Class<T> newSingletonClass(Class<T> cls, T singleton, InterceptorListener listener) {
        if (singleton == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        Class proxyClass = new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"finalize").and((ElementMatcher)ElementMatchers.hasParameters((ElementMatcher)ElementMatchers.none()))))).intercept((Implementation)MethodDelegation.toField((String)"handler")).defineField("handler", Handler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, Ownership.STATIC}).make().load(cls.getClassLoader()).getLoaded();
        try {
            Field field = proxyClass.getDeclaredField("handler");
            field.setAccessible(true);
            InterceptorHandlerWrapper wrapper = null;
            try {
                wrapper = new InterceptorHandlerWrapper(Interceptor.getInstance(), proxyClass, singleton, (t, thisMethod, args) -> thisMethod.invoke(singleton, args), listener);
                field.set(null, wrapper);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return proxyClass;
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler) {
        return this.newInterceptor(instance, handler, null);
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler, InterceptorListener listener) {
        Class proxyClass = this.createClass(instance.getClass());
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(this, proxyClass, instance, handler, listener);
        ((HandlerAccessor)proxyObject).setHandler(wrapper);
        return proxyObject;
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler) {
        return this.newInstance(cls, handler, null);
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler, InterceptorListener listener) {
        Class proxyClass = this.createClass(cls);
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = null;
        try {
            Object target = null;
            if (!cls.isInterface()) {
                target = cls.newInstance();
            }
            wrapper = new InterceptorHandlerWrapper(this, proxyClass, target, handler, listener);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        wrapper.targetClass = cls;
        ((HandlerAccessor)proxyObject).setHandler(wrapper);
        return proxyObject;
    }

    private <T> T newObject(Class proxyClass) {
        T proxyObject = null;
        try {
            proxyObject = proxyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return proxyObject;
    }

    public static boolean isProxyObject(Object proxyObject) {
        return proxyObject instanceof HandlerAccessor;
    }

    public static <T> T cloneProxyObject(T proxyObject) {
        if (!(proxyObject instanceof HandlerAccessor)) {
            throw new IllegalArgumentException("argument is not a proxy object");
        }
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper = wrapper.clone();
        Interceptor interceptor = wrapper.interceptor;
        T cloneProxy = interceptor.newObject(wrapper.proxyClass);
        ((HandlerAccessor)cloneProxy).setHandler(wrapper);
        return cloneProxy;
    }

    public static Object getTarget(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return wrapper.target;
    }

    public static void setTarget(Object proxyObject, Object target) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        if (target != null && !target.getClass().isAssignableFrom(wrapper.targetClass)) {
            throw new IllegalArgumentException("Target class " + target.getClass() + " is not assignable from " + wrapper.targetClass);
        }
        wrapper.target = target;
    }

    public static Class getTargetClass(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return wrapper.targetClass;
    }

    public static <T extends InterceptorHandler> T getInterceptorHandler(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.handler;
    }

    public static <T extends InterceptorHandler> void setInterceptorHandler(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper.handler = handler;
    }

    public static <T extends InterceptorListener> T getInterceptorListener(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        return (T)wrapper.listener;
    }

    public static <T extends InterceptorListener> void setInterceptorListener(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((HandlerAccessor)proxyObject).getHandler();
        wrapper.listener = handler;
    }

    private static class InterceptorHandlerWrapper
    implements Handler,
    Cloneable {
        InterceptorHandler handler;
        InterceptorListener listener;
        Object target;
        Class targetClass;
        Class proxyClass;
        Interceptor interceptor;

        public InterceptorHandlerWrapper(Interceptor interceptor, Class proxyClass, Object target, InterceptorHandler handler, InterceptorListener listener) {
            this.interceptor = interceptor;
            this.proxyClass = proxyClass;
            this.handler = handler;
            this.listener = listener;
            this.target = target;
            if (target != null) {
                this.targetClass = target.getClass();
            }
        }

        protected InterceptorHandlerWrapper clone() {
            try {
                return (InterceptorHandlerWrapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object handle(Method interceptorMethod, @RuntimeType Object[] arguments) throws Throwable {
            if (this.listener != null) {
                this.listener.preInvocation(this.target, interceptorMethod, arguments);
            }
            Object ret = null;
            try {
                ret = this.handler.invoke(this.target, interceptorMethod, arguments);
            }
            catch (Throwable throwable) {
                if (this.listener != null) {
                    return this.listener.onException(this.target, interceptorMethod, arguments, throwable);
                }
                throw throwable;
            }
            if (this.listener != null) {
                ret = this.listener.postInvocation(this.target, interceptorMethod, arguments, ret);
            }
            return ret;
        }
    }

    public static interface HandlerAccessor {
        public Handler getHandler();

        public void setHandler(Handler var1);
    }

    public static interface Handler {
        @RuntimeType
        public Object handle(@Origin Method var1, @AllArguments Object[] var2) throws Throwable;
    }

    public static class Constructor<T> {
        T prototype;

        public Constructor(T prototype) {
            this.prototype = prototype;
        }

        public void construct(@This Object instance) {
            if (this.prototype != null) {
                Reflection.copyInstance(instance, this.prototype);
            }
        }
    }
}

