/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.e6tech.elements.common.launch.CreatedListener;
import net.e6tech.elements.common.launch.Launch;
import net.e6tech.elements.common.launch.LaunchListener;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;

public class LaunchController
implements LaunchListener {
    private static Map<String, Provision> provisions = new HashMap<String, Provision>();
    private Properties properties = new Properties();
    private List<LaunchListener> listeners = new LinkedList<LaunchListener>();
    private List<String> arguments = new ArrayList<String>();

    public LaunchController() {
        this.property("home", System.getProperty("home", System.getProperty("user.dir")));
        this.property("env", System.getProperty("env", "dev"));
        this.properties.put("args", this.arguments);
    }

    protected LaunchController(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.properties.put("args", this.arguments);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public LaunchController property(String property, String value) {
        this.properties.setProperty(property, value);
        return this;
    }

    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getLaunchScript() {
        return this.properties.getProperty("launch");
    }

    public void setLaunchScript(String launchScript) {
        this.properties.setProperty("launch", launchScript);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public LaunchController launchScript(String launchScript) {
        this.setLaunchScript(launchScript);
        return this;
    }

    public LaunchController addLaunchListener(LaunchListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public LaunchController removeLaunchListener(LaunchListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public LaunchController addCreatedListener(CreatedListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public LaunchController removeCreatedListener(CreatedListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public LaunchController inject(Object object) {
        if (provisions.get(this.getLaunchScript()) != null) {
            provisions.get(this.getLaunchScript()).inject(object);
        } else {
            this.addLaunchListener(provision -> provision.inject(object));
        }
        return this;
    }

    @Override
    public void created(ResourceManager rm) {
        for (LaunchListener listener : this.listeners) {
            listener.created(rm);
        }
    }

    @Override
    public void launched(Provision provision) {
        provisions.put(this.getLaunchScript(), provision);
        for (LaunchListener listener : this.listeners) {
            listener.launched(provision);
        }
    }

    public LaunchController launch() {
        String launchScript = this.getLaunchScript();
        if (provisions.containsKey(launchScript)) {
            return this;
        }
        new Launch(this).launch(new LaunchListener[0]);
        return this;
    }
}

