/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.notification;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import net.e6tech.elements.common.notification.Notification;

public interface NotificationListener<T extends Notification> {
    public static <R extends Notification> NotificationListener<R> wrap(String description, NotificationListener<R> listener) {
        return (NotificationListener)Proxy.newProxyInstance(listener.getClass().getClassLoader(), new Class[]{NotificationListener.class}, (proxy, method, args) -> {
            if (method.getName().equals("getDescription") && (args == null || args.length == 0)) {
                return description;
            }
            return method.invoke((Object)listener, args);
        });
    }

    public static <R extends Notification> NotificationListener<R> wrap(Class<? extends Notification>[] types, NotificationListener<R> listener) {
        return (NotificationListener)Proxy.newProxyInstance(listener.getClass().getClassLoader(), new Class[]{NotificationListener.class}, (proxy, method, args) -> {
            if (method.getName().equals("getNotificationTypes") && (args == null || args.length == 0)) {
                return types;
            }
            return method.invoke((Object)listener, args);
        });
    }

    default public Class<? extends Notification>[] getNotificationTypes() {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = this.getClass().getGenericInterfaces()) {
            ParameterizedType parametrizedType;
            Type[] typeArguments;
            if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(NotificationListener.class) || (typeArguments = (parametrizedType = (ParameterizedType)genericInterface).getActualTypeArguments()).length <= 0 || !(typeArguments[0] instanceof Class)) continue;
            return new Class[]{(Class)typeArguments[0]};
        }
        return new Class[0];
    }

    default public String getDescription() {
        return this.getClass().getName();
    }

    public void onEvent(T var1);
}

