/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.concurrent.Callable;
import net.e6tech.elements.common.resources.Resources;

public interface Transactional {
    public <Res extends Resources> Res open();

    default public <R> R commit(Callable<R> callable) {
        Resources resources = this.open();
        resources.submit(r -> callable.call());
        return resources.commit();
    }

    default public void commit(RunnableWithException runnable) {
        Resources resources = this.open();
        resources.submit(r -> runnable.run());
        resources.commit();
    }

    default public <T, R> R commit(Class<T> cls, FunctionWithException<T, R> function) {
        Resources resources = this.open();
        resources.submit(r -> function.apply(r.getInstance(cls)));
        return resources.commit();
    }

    default public <T> void commit(Class<T> cls, ConsumerWithException<T> consumer) {
        Resources resources = this.open();
        resources.submit(r -> consumer.accept(r.getInstance(cls)));
        resources.commit();
    }

    default public <S, T, R> R commit(Class<S> cls, Class<T> cls2, BiFunctionWithException<S, T, R> function) {
        Resources resources = this.open();
        resources.submit(r -> function.apply(r.getInstance(cls), r.getInstance(cls2)));
        return resources.commit();
    }

    default public <S, T> void commit(Class<S> cls, Class<T> cls2, BiConsumerWithException<S, T> consumer) {
        Resources resources = this.open();
        resources.submit(r -> consumer.accept(r.getInstance(cls), r.getInstance(cls2)));
        resources.commit();
    }

    default public <S, T, U, R> R commit(Class<S> cls, Class<T> cls2, Class<U> cls3, TriFunctionWithException<S, T, U, R> function) {
        Resources resources = this.open();
        resources.submit(r -> function.apply(r.getInstance(cls), r.getInstance(cls2), r.getInstance(cls3)));
        return resources.commit();
    }

    default public <S, T, U> void commit(Class<S> cls, Class<T> cls2, Class<U> cls3, TriConsumerWithException<S, T, U> consumer) {
        Resources resources = this.open();
        resources.submit(r -> consumer.accept(r.getInstance(cls), r.getInstance(cls2), r.getInstance(cls3)));
        resources.commit();
    }

    @FunctionalInterface
    public static interface TriFunctionWithException<S, T, U, R> {
        public R apply(S var1, T var2, U var3) throws Throwable;
    }

    @FunctionalInterface
    public static interface BiFunctionWithException<S, T, R> {
        public R apply(S var1, T var2) throws Exception;
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R> {
        public R apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface TriConsumerWithException<S, T, U> {
        public void accept(S var1, T var2, U var3) throws Throwable;
    }

    @FunctionalInterface
    public static interface BiConsumerWithException<S, T> {
        public void accept(S var1, T var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ConsumerWithException<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface RunnableWithException {
        public void run() throws Throwable;
    }
}

