/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.script;

import groovy.lang.Closure;
import groovy.lang.GString;
import java.beans.Introspector;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.script.ScriptException;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.script.Scripting;

public abstract class AbstractScriptShell {
    private String env;
    private Map<String, List<String>> knownEnvironments = new LinkedHashMap<String, List<String>>();
    private Scripting scripting;
    private Properties properties;
    List<Runnable> cleanup = new LinkedList<Runnable>();
    boolean loading = false;

    protected AbstractScriptShell() {
    }

    protected AbstractScriptShell(Properties properties) {
        this.initialize(null, properties);
    }

    protected void initialize(ClassLoader classLoader, Properties properties) {
        int idx;
        if (properties == null) {
            properties = new Properties();
        }
        this.properties = properties;
        this.env = properties.getProperty("env");
        String originalScriptBase = properties.getProperty("scriptBaseClass");
        if (originalScriptBase == null) {
            String className = this.getClass().getName() + "Script";
            try {
                this.getClass().getClassLoader().loadClass(className);
                properties.put("scriptBaseClass", className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.env = properties.getProperty("env");
        this.scripting = Scripting.newInstance(classLoader, properties);
        if (originalScriptBase == null) {
            properties.remove("scriptBaseClass");
        } else {
            properties.put("scriptBaseClass", originalScriptBase);
        }
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.length() == 0 && (idx = (simpleName = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            simpleName = simpleName.substring(idx + 1);
        }
        String shellName = Introspector.decapitalize(simpleName);
        this.scripting.put(shellName, this);
        this.scripting.put("shell", this);
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void load(String str) throws ScriptException {
        try {
            this.loading = true;
            this.scripting.load(str);
            this.onLoaded();
        }
        finally {
            this.loading = false;
        }
    }

    protected void onLoaded() {
        for (Runnable r : this.cleanup) {
            r.run();
        }
        this.cleanup.clear();
        System.gc();
    }

    public void addCleanup(Runnable r) {
        this.cleanup.add(r);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        this.scripting.put(key, value);
    }

    public <T> T getVariable(String key) {
        return (T)this.getScripting().get(key);
    }

    public Map<String, List<String>> defineKnownEnvironments(String str) {
        this.knownEnvironments = Configuration.defineEnvironments(str);
        return this.knownEnvironments;
    }

    public Map<String, List<String>> getKnownEnvironments() {
        return this.knownEnvironments;
    }

    public void setKnownEnvironments(Map<String, List<String>> knownEnvironments) {
        this.knownEnvironments = knownEnvironments;
    }

    public void runAfter(Object callable) {
        this.scripting.runAfter(callable);
    }

    public void runAfter(Runnable callable) {
        this.scripting.runAfter(callable);
    }

    public void runAfterIfNotLoading() {
        if (!this.loading) {
            this.scripting.runAfter();
        }
    }

    public Object runNow(Object caller, Object callable) {
        return this.scripting.runNow(caller, callable);
    }

    public Object runNow(Object caller, Runnable callable) {
        return this.scripting.runNow(caller, callable);
    }

    public Object runNow(Object caller, Callable callable) {
        return this.scripting.runNow(caller, callable);
    }

    public void runLaunched(Runnable callable) {
        this.scripting.runLaunched(callable);
    }

    public Object exec(String path) {
        try {
            return this.getScripting().exec(path);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(Object ... items) {
        Object value = null;
        for (Object item : items) {
            try {
                if (item instanceof String || item instanceof GString) {
                    value = this.getScripting().exec(item.toString());
                    continue;
                }
                if (item instanceof Closure) {
                    String[] clonedClosure = (String[])((Closure)item).clone();
                    try {
                        clonedClosure.setResolveStrategy(1);
                        clonedClosure.setDelegate(value);
                        Object ret = clonedClosure.call(value);
                        if (ret == null) continue;
                        value = ret;
                        continue;
                    }
                    finally {
                        clonedClosure.setDelegate(null);
                    }
                }
                if (item instanceof String[]) {
                    for (String str : (String[])item) {
                        value = this.getScripting().exec(str);
                    }
                    continue;
                }
                value = item;
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Dir dir(String dir) {
        return new Dir(dir);
    }

    public static class Dir {
        private String dir;

        public Dir() {
            this.dir = "";
        }

        public Dir(String base) {
            this.dir = base;
            while ((this.dir.endsWith(File.separator) || this.dir.endsWith("/")) && !"classpath://".equals(this.dir) && !"classpath:/".equals(this.dir)) {
                this.dir = this.dir.substring(0, this.dir.length() - 1);
            }
        }

        public String[] expand(String ... items) {
            if (items == null) {
                return new String[0];
            }
            String[] paths = new String[items.length];
            for (int i = 0; i < paths.length; ++i) {
                String item = items[i];
                while (item.startsWith(File.separator) || item.startsWith("/")) {
                    item = item.substring(1);
                }
                if (!item.endsWith(".groovy")) {
                    item = item + ".groovy";
                }
                paths[i] = this.dir + "/" + item;
            }
            return paths;
        }
    }
}

