/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.subscribe;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.common.util.concurrent.ThreadPool;

public class DefaultBroadcast
implements Broadcast {
    Logger logger = Logger.getLogger();
    Map<String, List<Subscriber>> subscribers = new HashMap<String, List<Subscriber>>();
    Map<String, List<Subscriber>> copy = new HashMap<String, List<Subscriber>>();
    ExecutorService threadPool;

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(String topic, Subscriber subscriber) {
        List list;
        List list2 = list = this.subscribers.computeIfAbsent(topic, key -> new LinkedList());
        synchronized (list2) {
            list.add(subscriber);
            LinkedList copyList = new LinkedList(list);
            this.copy.put(topic, copyList);
        }
    }

    @Override
    public <T extends Serializable> void subscribe(Class<T> topic, Subscriber<T> listener) {
        this.subscribe(topic.getName(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(String topic, Subscriber subscriber) {
        List list;
        List list2 = list = this.subscribers.computeIfAbsent(topic, key -> new LinkedList());
        synchronized (list2) {
            list.remove(subscriber);
            LinkedList copyList = new LinkedList(list);
            this.copy.put(topic, copyList);
        }
    }

    @Override
    public void unsubscribe(Class topic, Subscriber subscriber) {
        this.unsubscribe(topic.getName(), subscriber);
    }

    @Override
    public void publish(String topic, Serializable object) {
        this.threadPool.execute(() -> {
            try {
                Notice<Serializable> notice = new Notice<Serializable>(topic, object);
                List list = this.subscribers.computeIfAbsent(topic, key -> new LinkedList());
                List list2 = list;
                synchronized (list2) {
                    list = this.copy.computeIfAbsent(topic, key -> new LinkedList());
                }
                for (Subscriber subscriber : list) {
                    subscriber.receive(notice);
                }
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage(), e);
            }
        });
    }

    @Override
    public <T extends Serializable> void publish(Class<T> cls, T object) {
        this.publish(cls.getName(), object);
    }

    private ExecutorService getThreadPool() {
        return ThreadPool.cachedThreadPool("Broadcast");
    }
}

