/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.common.reflection.Reflection;

public abstract class Balancer<T> {
    private BlockingQueue<T> liveList = new LinkedBlockingQueue<T>();
    private BlockingQueue<T> deadList = new LinkedBlockingQueue<T>();
    private long timeout = 3000L;
    private long recoveryPeriod = 60000L;
    private Thread recoveryThread;

    public T getService() {
        Class cls = Reflection.getParametrizedType(this.getClass(), 0);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cls}, (proxy, method, args) -> this.execute(service -> {
            try {
                return method.invoke(service, args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getRecoveryPeriod() {
        return this.recoveryPeriod;
    }

    public void setRecoveryPeriod(long recoveryPeriod) {
        this.recoveryPeriod = recoveryPeriod;
    }

    public void addService(T service) {
        this.liveList.add(service);
    }

    public void start() {
        Iterator iterator = this.liveList.iterator();
        while (iterator.hasNext()) {
            Object service = iterator.next();
            try {
                this.start(service);
            }
            catch (Throwable th) {
                iterator.remove();
                this.recover(service);
            }
        }
    }

    protected abstract void start(T var1) throws IOException;

    protected abstract void stop(T var1) throws IOException;

    private void recoverTask() {
        LinkedList list = new LinkedList();
        while (true) {
            list.clear();
            Object service = this.deadList.poll();
            try {
                this.start(service);
                this.liveList.offer(service);
            }
            catch (Throwable ex) {
                try {
                    this.stop(service);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                list.add(service);
            }
            list.forEach(h -> this.deadList.offer(h));
            try {
                Thread.sleep(this.recoveryPeriod);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    protected synchronized void recover(T service) {
        try {
            this.stop(service);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.deadList.offer(service);
        if (this.recoveryThread == null) {
            this.recoveryThread = new Thread(this::recoverTask);
            this.recoveryThread.start();
        }
    }

    public <R> R execute(Submit<T, R> submit) throws IOException {
        while (true) {
            T service;
            try {
                service = this.liveList.poll(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException();
            }
            try {
                R ret = submit.apply(service);
                this.liveList.offer(service);
                return ret;
            }
            catch (IOException ex) {
                this.recover(service);
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    public static interface Submit<T, R> {
        public R apply(T var1) throws IOException;
    }
}

