/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.concurrent;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.e6tech.elements.common.resources.BindClass;

@BindClass(value=ExecutorService.class)
public class ThreadPool
implements ThreadFactory,
ExecutorService {
    private static Map<String, ThreadPool> cachedThreadPools = new Hashtable<String, ThreadPool>();
    private static Map<String, ThreadPool> rateLimitedThreadPools = new Hashtable<String, ThreadPool>();
    private static Map<String, ThreadPool> fixedThreadPools = new Hashtable<String, ThreadPool>();
    private ThreadGroup threadGroup;
    private String name;
    private boolean daemon = true;
    private ExecutorService executorService;

    public static ThreadPool cachedThreadPool(String name) {
        return cachedThreadPools.computeIfAbsent(name, poolName -> new ThreadPool(name, p -> Executors.newCachedThreadPool(p)));
    }

    public static ThreadPool rateLimitedThreadPool(String name, int threadCoreSize, int threadMaxSize, long threadKeepAliveSec, int threadQueueSize) {
        return rateLimitedThreadPools.computeIfAbsent(name, poolName -> new ThreadPool(name, p -> new ThreadPoolExecutor(threadCoreSize, threadMaxSize, threadKeepAliveSec, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(threadQueueSize), (ThreadFactory)p)));
    }

    public static ThreadPool fixedThreadPool(String name, int nThreads) {
        return fixedThreadPools.computeIfAbsent(name, poolName -> new ThreadPool(name, p -> Executors.newFixedThreadPool(nThreads, p)));
    }

    protected ThreadPool(ThreadGroup threadGroup, String name, Function<ThreadFactory, ExecutorService> newPool) {
        this.threadGroup = threadGroup;
        this.name = name;
        this.executorService = newPool.apply(this);
    }

    protected ThreadPool(String name, Function<ThreadFactory, ExecutorService> newPool) {
        this(Thread.currentThread().getThreadGroup(), name, newPool);
    }

    public ThreadPool daemon() {
        return this.daemon(true);
    }

    public ThreadPool daemon(boolean b) {
        this.daemon = b;
        return this;
    }

    public ThreadPool threadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        return this;
    }

    public ThreadPool rejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        if (this.executorService instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.executorService).setRejectedExecutionHandler(handler);
        }
        return this;
    }

    public <T extends ExecutorService> T unwrap() {
        return (T)this.executorService;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.threadGroup, runnable, "Broadcast");
        thread.setName(this.name + "-" + thread.getId());
        thread.setDaemon(this.daemon);
        return thread;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }
}

