/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.datastructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinarySearchList
implements Iterable<Comparable> {
    private List<Comparable> sortedList = new ArrayList<Comparable>();

    @Override
    public Iterator<Comparable> iterator() {
        return this.sortedList.iterator();
    }

    public int size() {
        return this.sortedList.size();
    }

    public boolean add(Comparable cmp) {
        this._add(0, this.sortedList.size() - 1, cmp);
        return true;
    }

    public void check() {
        Comparable prev = null;
        for (Comparable c : this.sortedList) {
            if (prev == null) {
                prev = c;
            }
            if (prev.compareTo(c) <= 0) continue;
            throw new IllegalStateException();
        }
    }

    public Comparable get(int i) {
        return this.sortedList.get(i);
    }

    private void _add(int min, int max, Comparable cmp) {
        if (this.size() == 0) {
            this.sortedList.add(cmp);
            return;
        }
        if (min == max) {
            Comparable candidate = this.get(min);
            int order = candidate.compareTo(cmp);
            if (order == 0 || order > 0) {
                this.sortedList.add(min, cmp);
            } else if (candidate.compareTo(cmp) < 0) {
                this.sortedList.add(min + 1, cmp);
            }
            return;
        }
        int index = (max + min + 1) / 2;
        Comparable candidate = this.get(index);
        if (candidate.compareTo(cmp) == 0) {
            this.sortedList.add(index, cmp);
            return;
        }
        if (candidate.compareTo(cmp) > 0) {
            this._add(min, (max + min) / 2, cmp);
        } else if (candidate.compareTo(cmp) < 0) {
            this._add(index, max, cmp);
        }
    }

    public boolean remove(Comparable cmp) {
        return this._remove(0, this.sortedList.size() - 1, cmp);
    }

    private boolean _remove(int min, int max, Comparable cmp) {
        if (this.size() == 0) {
            return false;
        }
        if (min == max) {
            Comparable candidate = this.get(min);
            int order = candidate.compareTo(cmp);
            if (order == 0) {
                Comparable left;
                Comparable right;
                int i;
                int modifiableSize = this.size();
                boolean found = false;
                for (i = min; i < modifiableSize && (right = this.get(i)).compareTo(cmp) == 0; ++i) {
                    if (!right.equals(cmp)) continue;
                    this.sortedList.remove(i);
                    --i;
                    --modifiableSize;
                    found = true;
                }
                for (i = min - 1; i >= 0 && (left = this.get(i)).compareTo(cmp) == 0; --i) {
                    if (!left.equals(cmp)) continue;
                    this.sortedList.remove(i);
                    found = true;
                }
                return found;
            }
            return false;
        }
        int index = (max + min + 1) / 2;
        Comparable candidate = this.get(index);
        if (candidate.compareTo(cmp) == 0) {
            return this._remove(index, index, cmp);
        }
        if (candidate.compareTo(cmp) > 0) {
            return this._remove(min, (max + min) / 2, cmp);
        }
        if (candidate.compareTo(cmp) < 0) {
            return this._remove(index, max, cmp);
        }
        return false;
    }
}

